/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import divinerpg.block_entities.AltarOfCorruptionBlockEntity;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderAltarOfCorruption
implements BlockEntityRenderer<AltarOfCorruptionBlockEntity> {
    public static final Material TEXTURE_BOOK = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/model/altar_book.png"));
    private final BookModel bookModel;

    public RenderAltarOfCorruption(BlockEntityRendererProvider.Context context) {
        this.bookModel = new BookModel(context.bakeLayer(ModelLayers.BOOK));
    }

    public void render(AltarOfCorruptionBlockEntity blockEntity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float f1;
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5, 0.75, 0.5);
        float f = (float)blockEntity.time + partialTicks;
        matrixStackIn.translate(0.0, (double)(0.1f + Mth.sin((float)(f * 0.1f)) * 0.01f), 0.0);
        for (f1 = blockEntity.rot - blockEntity.oRot; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        float f2 = blockEntity.oRot + f1 * partialTicks;
        matrixStackIn.mulPose(Axis.YP.rotation(-f2));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(80.0f));
        float f3 = Mth.lerp((float)partialTicks, (float)blockEntity.oFlip, (float)blockEntity.flip);
        float f4 = Mth.frac((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = Mth.frac((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = Mth.lerp((float)partialTicks, (float)blockEntity.oOpen, (float)blockEntity.open);
        this.bookModel.setupAnim(f, Mth.clamp((float)f4, (float)0.0f, (float)1.0f), Mth.clamp((float)f5, (float)0.0f, (float)1.0f), f6);
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE_BOOK.texture()));
        this.bookModel.renderToBuffer(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.popPose();
    }
}

