/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import divinerpg.client.models.block.ModelBoneChest;
import divinerpg.registries.BlockRegistry;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class RenderBoneChestItem
extends BlockEntityWithoutLevelRenderer {
    private final ModelBoneChest<?> model;

    public RenderBoneChestItem(BlockEntityRenderDispatcher dispatcher, EntityModelSet set) {
        super(dispatcher, set);
        this.model = new ModelBoneChest(set.bakeLayer(ModelBoneChest.LAYER_LOCATION));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext context, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.renderByItem(stack, context, matrixStack, buffer, combinedLight, combinedOverlay);
        Item item = stack.getItem();
        if (item == BlockRegistry.boneChest.asItem()) {
            matrixStack.pushPose();
            matrixStack.translate(0.0, 1.0, 0.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            VertexConsumer builder = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/model/bone_chest.png")));
            this.model.renderToBuffer(matrixStack, builder, combinedLight, combinedOverlay);
            matrixStack.popPose();
        }
    }
}

