/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.entity.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import divinerpg.client.models.twilight.ModelGemFin;
import divinerpg.entities.eden.EntityGemFin;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderGemFin
extends MobRenderer<EntityGemFin, ModelGemFin> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/entity/gem_fin/patchy_gem_fin.png");
    private static final ResourceLocation TEXTURE1 = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/entity/gem_fin/precious_gem_fin.png");
    private static final ResourceLocation TEXTURE2 = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/entity/gem_fin/ruby_gem_fin.png");

    public RenderGemFin(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelGemFin(context), 0.32f);
    }

    public ResourceLocation getTextureLocation(EntityGemFin entity) {
        return switch (entity.getVariant()) {
            case 0 -> TEXTURE;
            case 1 -> TEXTURE1;
            default -> TEXTURE2;
        };
    }

    protected void setupRotations(EntityGemFin entity, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations((LivingEntity)entity, poseStack, bob, yBodyRot, partialTick, scale);
        float f = 4.3f * Mth.sin((float)(0.6f * bob));
        poseStack.mulPose(Axis.YP.rotationDegrees(f));
        if (!entity.isInWater()) {
            poseStack.translate(0.2f, 0.2f, 0.0f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

