/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleTar
extends TextureSheetParticle {
    SpriteSet sprites;

    protected ParticleTar(ClientLevel level, double xCoord, double yCoord, double zCoord, double xd, double yd, double zd, SpriteSet sprite) {
        super(level, xCoord, yCoord, zCoord);
        this.xd *= xd * 0.2 + (Math.random() * 2.0 - 1.0) * 0.02;
        this.yd *= yd * 0.1 + (Math.random() * 2.0 - 1.0) * 0.01;
        this.zd *= zd * 0.2 + (Math.random() * 2.0 - 1.0) * 0.02;
        this.quadSize = (float)((double)this.quadSize * ((double)this.random.nextFloat() * 0.6 + 0.2));
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.sprites = sprite;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        } else {
            this.yd += 0.002;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.85;
            this.yd *= 0.85;
            this.zd *= 0.85;
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed) {
            ParticleTar particle = new ParticleTar(world, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed, this.sprites);
            particle.pickSprite(this.sprites);
            return particle;
        }
    }
}

