/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Mob;

public class ModelWatcher
extends EntityModel<Mob> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("watcher");
    private final ModelPart Head;
    private final ModelPart Jaw;
    private final ModelPart Tentacle11;
    private final ModelPart Tentacle12;
    private final ModelPart Tentacle21;
    private final ModelPart Tentacle22;
    private final ModelPart Tentacle31;
    private final ModelPart Tentacle32;

    public ModelWatcher(ModelPart root) {
        this.Head = root.getChild("Head");
        this.Jaw = root.getChild("Jaw");
        this.Tentacle11 = root.getChild("Tentacle11");
        this.Tentacle12 = root.getChild("Tentacle12");
        this.Tentacle21 = root.getChild("Tentacle21");
        this.Tentacle22 = root.getChild("Tentacle22");
        this.Tentacle31 = root.getChild("Tentacle31");
        this.Tentacle32 = root.getChild("Tentacle32");
    }

    public ModelWatcher(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Head = root.getChild("Head");
        this.Jaw = root.getChild("Jaw");
        this.Tentacle11 = root.getChild("Tentacle11");
        this.Tentacle12 = root.getChild("Tentacle12");
        this.Tentacle21 = root.getChild("Tentacle21");
        this.Tentacle22 = root.getChild("Tentacle22");
        this.Tentacle31 = root.getChild("Tentacle31");
        this.Tentacle32 = root.getChild("Tentacle32");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        Head.addOrReplaceChild("Head_r1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-5.0f, -13.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition Jaw = partdefinition.addOrReplaceChild("Jaw", CubeListBuilder.create(), PartPose.offset((float)5.0f, (float)21.0f, (float)5.0f));
        Jaw.addOrReplaceChild("Jaw_r1", CubeListBuilder.create().texOffs(0, 20).mirror().addBox(0.0f, 0.0f, 0.0f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)3.1416f, (float)0.0f));
        PartDefinition Tentacle11 = partdefinition.addOrReplaceChild("Tentacle11", CubeListBuilder.create(), PartPose.offset((float)5.0f, (float)16.0f, (float)0.0f));
        Tentacle11.addOrReplaceChild("Tentacle11_r1", CubeListBuilder.create().texOffs(40, 0).mirror().addBox(-1.0f, -9.0f, 1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition Tentacle12 = partdefinition.addOrReplaceChild("Tentacle12", CubeListBuilder.create(), PartPose.offset((float)9.0f, (float)16.0f, (float)0.0f));
        Tentacle12.addOrReplaceChild("Tentacle12_r1", CubeListBuilder.create().texOffs(40, 6).mirror().addBox(-1.0f, -9.0f, -1.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-18.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition Tentacle21 = partdefinition.addOrReplaceChild("Tentacle21", CubeListBuilder.create(), PartPose.offset((float)-5.0f, (float)16.0f, (float)0.0f));
        Tentacle21.addOrReplaceChild("Tentacle21_r1", CubeListBuilder.create().texOffs(40, 0).mirror().addBox(-1.0f, -9.0f, 1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition Tentacle22 = partdefinition.addOrReplaceChild("Tentacle22", CubeListBuilder.create(), PartPose.offset((float)-9.0f, (float)16.0f, (float)0.0f));
        Tentacle22.addOrReplaceChild("Tentacle22_r1", CubeListBuilder.create().texOffs(40, 6).mirror().addBox(-1.0f, -9.0f, -1.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)18.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition Tentacle31 = partdefinition.addOrReplaceChild("Tentacle31", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)11.0f, (float)0.0f));
        Tentacle31.addOrReplaceChild("Tentacle31_r1", CubeListBuilder.create().texOffs(52, 0).mirror().addBox(-1.0f, -16.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition Tentacle32 = partdefinition.addOrReplaceChild("Tentacle32", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        Tentacle32.addOrReplaceChild("Tentacle32_r1", CubeListBuilder.create().texOffs(40, 6).mirror().addBox(-4.0f, -18.0f, -1.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)17.0f, (float)-3.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(Mob entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Jaw.xRot = (float)(Math.cos(ageInTicks * 0.3f) * Math.PI * (double)0.0417f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Jaw.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Tentacle11.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Tentacle12.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Tentacle21.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Tentacle22.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Tentacle31.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Tentacle32.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

