/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.IAttackTimer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.TamableAnimal;

public class ModelStoneGolem<T extends TamableAnimal>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("stone_golem");
    private final ModelPart crystal;
    private final ModelPart rings;
    private final ModelPart head;
    private final ModelPart Body;
    private final ModelPart leftarm;
    private final ModelPart rightarm;

    public ModelStoneGolem(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.crystal = root.getChild("crystal");
        this.rings = root.getChild("rings");
        this.head = root.getChild("head");
        this.Body = root.getChild("Body");
        this.leftarm = root.getChild("leftarm");
        this.rightarm = root.getChild("rightarm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("crystal", CubeListBuilder.create().texOffs(104, 94).mirror().addBox(-2.4216f, -2.3006f, -2.4172f, 5.0f, 5.0f, 5.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-1.0f, (float)0.7854f, (float)0.4363f, (float)0.6109f));
        partdefinition.addOrReplaceChild("rings", CubeListBuilder.create().texOffs(52, 117).mirror().addBox(1.5f, 4.0f, 2.0f, 7.0f, 0.0f, 7.0f, CubeDeformation.NONE).mirror(false).texOffs(52, 94).mirror().addBox(-1.5f, -4.0f, -2.0f, 13.0f, 0.0f, 13.0f, CubeDeformation.NONE).mirror(false).texOffs(52, 107).mirror().addBox(0.0f, 0.0f, 0.0f, 10.0f, 0.0f, 10.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-4.0f, (float)12.0f, (float)-5.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(38, 0).mirror().addBox(-4.5f, -2.0f, -5.0f, 11.0f, 4.0f, 11.0f, CubeDeformation.NONE).mirror(false).texOffs(0, 0).mirror().addBox(-4.0f, -6.0f, -3.0f, 10.0f, 4.0f, 9.0f, CubeDeformation.NONE).mirror(false).texOffs(90, 16).mirror().addBox(-4.0f, -11.0f, 2.0f, 10.0f, 3.0f, 4.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 0).mirror().addBox(-4.0f, -4.0f, -4.0f, 10.0f, 6.0f, 1.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 7).mirror().addBox(-4.0f, -6.0f, -4.0f, 1.0f, 2.0f, 1.0f, CubeDeformation.NONE).mirror(false).texOffs(86, 7).mirror().addBox(-1.0f, -6.0f, -4.0f, 4.0f, 2.0f, 1.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 7).mirror().addBox(5.0f, -6.0f, -4.0f, 1.0f, 2.0f, 1.0f, CubeDeformation.NONE).mirror(false).texOffs(0, 40).mirror().addBox(-4.0f, -8.0f, -4.0f, 10.0f, 2.0f, 10.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-1.0f, (float)-22.0f, (float)-1.0f));
        head.addOrReplaceChild("crown1_r1", CubeListBuilder.create().texOffs(56, 16).mirror().addBox(-4.0f, -3.9f, -5.7f, 8.0f, 4.0f, 7.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)-7.0f, (float)3.0f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(7.5f, -9.2f, -2.0f, 10.0f, 10.0f, 11.0f, CubeDeformation.NONE).mirror(false).texOffs(0, 18).mirror().addBox(-2.0f, 0.0f, -2.0f, 10.0f, 10.0f, 11.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)-13.5f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        Body.addOrReplaceChild("Body_r1", CubeListBuilder.create().texOffs(0, 68).mirror().addBox(-12.0f, -11.0f, -7.0f, 28.0f, 13.0f, 13.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)5.0f, (float)0.5f, (float)4.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(0, 94).mirror().addBox(-6.0f, -6.0f, -7.0f, 12.0f, 12.0f, 14.0f, CubeDeformation.NONE).mirror(false).texOffs(40, 42).mirror().addBox(-3.0f, 5.0f, -4.0f, 8.0f, 13.0f, 8.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 69).mirror().addBox(-3.0f, 18.0f, -5.0f, 9.0f, 13.0f, 10.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 28).mirror().addBox(-3.5f, 30.0f, -5.5f, 10.0f, 3.0f, 11.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 28).mirror().addBox(0.5f, 33.0f, -4.5f, 2.0f, 3.0f, 1.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 28).mirror().addBox(-2.5f, 33.0f, -1.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 28).mirror().addBox(0.5f, 33.0f, 3.5f, 2.0f, 3.0f, 1.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 28).mirror().addBox(4.5f, 33.0f, -1.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)18.0f, (float)-16.0f, (float)-0.5f));
        partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(0, 94).mirror().addBox(-6.0f, -6.0f, -7.0f, 12.0f, 12.0f, 14.0f, CubeDeformation.NONE).mirror(false).texOffs(40, 42).mirror().addBox(-5.0f, 5.0f, -4.0f, 8.0f, 13.0f, 8.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 69).mirror().addBox(-6.0f, 18.0f, -5.0f, 9.0f, 13.0f, 10.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 28).mirror().addBox(-6.5f, 30.0f, -5.5f, 10.0f, 3.0f, 11.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 28).mirror().addBox(-5.5f, 33.0f, -1.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 28).mirror().addBox(-2.5f, 33.0f, 3.5f, 2.0f, 3.0f, 1.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 28).mirror().addBox(1.5f, 33.0f, -1.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.NONE).mirror(false).texOffs(82, 28).mirror().addBox(-2.5f, 33.0f, -4.5f, 2.0f, 3.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-18.0f, (float)-16.0f, (float)-0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.crystal.xRot += (float)(Math.cos(ageInTicks * 0.3f) * Math.PI * (double)0.3f);
        this.crystal.yRot += (float)(Math.cos(ageInTicks * 0.3f) * Math.PI * (double)0.3f);
    }

    public void prepareMobModel(T e, float par2, float par3, float par4) {
        float r = 0.0f;
        float armR = (float)(Math.cos((double)(par2 * 0.6662f) + Math.PI) * (double)par3 * 0.5);
        float armL = (float)(Math.cos(par2 * 0.6662f) * (double)par3 * 0.5);
        if (((IAttackTimer)e).getAttackTimer() > 0) {
            r = this.getSwingAngle((float)((IAttackTimer)e).getAttackTimer() - par4, 10.0f) - 1.0f;
        }
        this.rightarm.xRot = r + armR;
        this.leftarm.xRot = r + armL;
    }

    private float getSwingAngle(float timer, float maxTimer) {
        return (Math.abs(timer - maxTimer / 2.0f) - maxTimer * 0.25f) / (maxTimer * 0.25f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.crystal.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rings.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

