/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityShark;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelShark<T extends EntityShark>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("shark");
    private final ModelPart Spine;
    private final ModelPart flipperL;
    private final ModelPart flipperR;
    private final ModelPart tail;
    private final ModelPart Jaw;

    public ModelShark(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Jaw = root.getChild("Jaw");
        this.Spine = root.getChild("Spine");
        this.flipperL = root.getChild("LeftFinBone");
        this.flipperR = root.getChild("RightFinBone");
        this.tail = root.getChild("Tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Spine = partdefinition.addOrReplaceChild("Spine", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)17.0f, (float)4.0f));
        Spine.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(34, 21).addBox(-5.0f, -0.5f, -8.8333f, 10.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-5.0f, -6.5f, -15.8333f, 10.0f, 6.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.5f, (float)-4.1667f));
        partdefinition.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(35, 0).addBox(-5.0f, -1.0f, -7.0f, 10.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)-2.0f));
        PartDefinition Torso = Spine.addOrReplaceChild("Torso", CubeListBuilder.create().texOffs(71, -9).addBox(0.0f, -10.0f, -2.0f, 0.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 21).addBox(-6.0f, -5.0f, -4.0f, 12.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("RightFinBone", CubeListBuilder.create().texOffs(47, 63).addBox(-6.5f, -1.0f, -2.5f, 7.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.5f, (float)18.0f, (float)1.5f));
        partdefinition.addOrReplaceChild("LeftFinBone", CubeListBuilder.create().texOffs(47, 56).addBox(0.5f, -1.0f, -2.5f, 7.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.5f, (float)18.0f, (float)1.5f));
        Torso.addOrReplaceChild("Pelvis", CubeListBuilder.create().texOffs(37, 36).addBox(-3.0f, -5.0f, -2.0f, 6.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)6.0f));
        PartDefinition Tail = partdefinition.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(17, 52).addBox(-2.0f, -3.25f, 0.75f, 4.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.75f, (float)10.25f));
        Tail.addOrReplaceChild("TailFin", CubeListBuilder.create().texOffs(0, 69).addBox(0.0f, -9.5f, -2.0f, 0.0f, 17.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)8.75f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityShark entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.flipperL.zRot = (float)(-Math.sin((double)(10.0f * ageInTicks) / 57.29577951308232) * (double)0.3f);
        this.flipperR.zRot = (float)(Math.sin((double)(10.0f * ageInTicks) / 57.29577951308232) * (double)0.3f);
        this.tail.yRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)limbSwingAmount);
    }

    public void prepareMobModel(T p_103621_, float p_103622_, float p_103623_, float p_103624_) {
        super.prepareMobModel(p_103621_, p_103622_, p_103623_, p_103624_);
        int l = ((EntityShark)((Object)p_103621_)).getAttackTick();
        this.Jaw.xRot = l > 0 ? (l > 5 ? Mth.sin((float)(((float)(-4 + l) - p_103624_) / 4.0f)) * (float)Math.PI * 0.4f : 0.15707964f * Mth.sin((float)((float)Math.PI * ((float)l - p_103624_) / 10.0f))) : 0.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Jaw.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Spine.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.flipperL.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.flipperR.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

