/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityRainbour;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelRainbour
extends EntityModel<EntityRainbour> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("rainbour");
    public final ModelPart body;
    public final ModelPart tail1;
    public final ModelPart tail2;
    public final ModelPart head;
    public final ModelPart lwing1;
    public final ModelPart lwing2;
    public final ModelPart lwing3;
    public final ModelPart rwing1;
    public final ModelPart rwing2;
    public final ModelPart rwing3;
    public final ModelPart lhip;
    public final ModelPart rhip;

    public ModelRainbour(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.tail1 = root.getChild("tail1");
        this.tail2 = this.tail1.getChild("tail2");
        this.head = root.getChild("head");
        this.lwing1 = root.getChild("lwing1");
        this.lwing2 = this.lwing1.getChild("lwing2");
        this.lwing3 = this.lwing2.getChild("lwing3");
        this.rwing1 = root.getChild("rwing1");
        this.rwing2 = this.rwing1.getChild("rwing2");
        this.rwing3 = this.rwing2.getChild("rwing3");
        this.lhip = root.getChild("lhip");
        this.rhip = root.getChild("rhip");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(58, 0).mirror().addBox(-3.0f, 1.0f, 1.0f, 6.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 0).mirror().addBox(-4.0f, -4.0f, 0.0f, 8.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)14.0f, (float)-5.0f));
        PartDefinition tail1 = partdefinition.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(48, 50).mirror().addBox(-3.0f, -2.5f, 0.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(49, 40).mirror().addBox(-2.0f, -2.0f, 5.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)13.0f, (float)5.5f));
        tail1.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(68, 41).mirror().addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(73, 52).mirror().addBox(-5.5f, -1.0f, 4.0f, 11.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)9.5f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(34, 41).mirror().addBox(-2.0f, -1.2f, -7.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 27).mirror().addBox(-3.0f, -2.0f, -5.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)12.5f, (float)-5.0f));
        head.addOrReplaceChild("lhorn1_r1", CubeListBuilder.create().texOffs(24, 27).mirror().addBox(-0.5f, -4.0f, -3.5f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(25, 34).mirror().addBox(-0.5f, -6.0f, -2.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(30, 34).mirror().addBox(-6.5f, -6.0f, -2.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(30, 27).mirror().addBox(-6.5f, -4.0f, -3.5f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)0.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("hornything_r1", CubeListBuilder.create().texOffs(49, 0).mirror().addBox(-1.0f, -8.9f, -19.8f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)17.0f, (float)5.0f, (float)-0.8029f, (float)0.0f, (float)0.0f));
        PartDefinition lwing1 = partdefinition.addOrReplaceChild("lwing1", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(0.0f, 0.0f, -2.0f, 9.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)12.0f, (float)-3.0f, (float)0.0f, (float)-0.3665f, (float)0.0f));
        PartDefinition lwing2 = lwing1.addOrReplaceChild("lwing2", CubeListBuilder.create().texOffs(0, 39).mirror().addBox(4.0f, 0.0f, 0.0f, 8.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-0.01f, (float)0.0f, (float)0.0f, (float)0.5585f, (float)0.0f));
        lwing2.addOrReplaceChild("lwing3", CubeListBuilder.create().texOffs(0, 50).mirror().addBox(11.0f, 0.0f, -5.0f, 14.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.44f, (float)-0.01f, (float)-0.5f, (float)0.0f, (float)-0.4538f, (float)0.0f));
        PartDefinition rwing1 = partdefinition.addOrReplaceChild("rwing1", CubeListBuilder.create().texOffs(33, 18).mirror().addBox(-9.0f, 0.0f, -2.0f, 9.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)12.0f, (float)-3.0f, (float)0.0f, (float)0.3665f, (float)0.0f));
        PartDefinition rwing2 = rwing1.addOrReplaceChild("rwing2", CubeListBuilder.create().texOffs(38, 28).mirror().addBox(-12.0f, 0.0f, 0.0f, 8.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-0.01f, (float)0.0f, (float)0.0f, (float)-0.5585f, (float)0.0f));
        rwing2.addOrReplaceChild("rwing3", CubeListBuilder.create().texOffs(66, 15).mirror().addBox(-25.0f, 0.0f, -5.0f, 14.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.44f, (float)-0.01f, (float)-0.5f, (float)0.0f, (float)0.4538f, (float)0.0f));
        PartDefinition lhip = partdefinition.addOrReplaceChild("lhip", CubeListBuilder.create().texOffs(73, 28).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.0f, (float)15.0f, (float)2.0f));
        lhip.addOrReplaceChild("lfoot_r1", CubeListBuilder.create().texOffs(56, 12).mirror().addBox(2.5f, -10.5f, 2.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)15.0f, (float)-2.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        lhip.addOrReplaceChild("lthigh", CubeListBuilder.create().texOffs(99, 29).mirror().addBox(-1.0f, 3.0f, -3.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7679f, (float)0.0f, (float)0.0f));
        PartDefinition rhip = partdefinition.addOrReplaceChild("rhip", CubeListBuilder.create().texOffs(86, 28).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)15.0f, (float)2.0f));
        rhip.addOrReplaceChild("rfoot_r1", CubeListBuilder.create().texOffs(61, 12).mirror().addBox(-3.5f, -10.5f, 2.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)15.0f, (float)-2.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        rhip.addOrReplaceChild("rthigh", CubeListBuilder.create().texOffs(39, 1).mirror().addBox(-1.0f, 3.0f, -3.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7679f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(EntityRainbour entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float t;
        this.head.xRot = headPitch / 60.0f;
        this.head.yRot = netHeadYaw / 60.0f;
        if (!entity.onGround()) {
            this.rhip.xRot = 0.3927f;
            this.lhip.xRot = 0.3927f;
        } else {
            this.lhip.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount) - 0.227f;
            this.rhip.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount) - 0.227f;
        }
        this.rwing1.zRot = (float)(Math.cos(ageInTicks * 0.3f) * Math.PI * (double)0.3f);
        this.lwing1.zRot = (float)(Math.cos(ageInTicks * 0.3f) * Math.PI * (double)-0.3f);
        this.tail1.xRot = t = (float)(Math.cos(limbSwing * 0.3f) * (double)limbSwingAmount / 2.0);
        this.tail2.xRot = t * 2.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.tail1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.lwing1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rwing1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.lhip.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rhip.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

