/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityPumpkinSpider;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelPumpkinSpider
extends EntityModel<EntityPumpkinSpider> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("pumpkin_spider");
    public final ModelPart Head;
    public final ModelPart Body;
    public final ModelPart Thorax;
    public final ModelPart RightLeg4;
    public final ModelPart RightLeg3;
    public final ModelPart RightLeg2;
    public final ModelPart RightLeg1;
    public final ModelPart LeftLeg4;
    public final ModelPart LeftLeg3;
    public final ModelPart LeftLeg2;
    public final ModelPart LeftLeg1;

    public ModelPumpkinSpider(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.Thorax = root.getChild("Thorax");
        this.RightLeg4 = root.getChild("RightLeg4");
        this.RightLeg3 = root.getChild("RightLeg3");
        this.RightLeg2 = root.getChild("RightLeg2");
        this.RightLeg1 = root.getChild("RightLeg1");
        this.LeftLeg4 = root.getChild("LeftLeg4");
        this.LeftLeg3 = root.getChild("LeftLeg3");
        this.LeftLeg2 = root.getChild("LeftLeg2");
        this.LeftLeg1 = root.getChild("LeftLeg1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(38, 32).addBox(-5.0f, -4.0f, -8.0f, 10.0f, 9.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)15.0f, (float)-7.0f));
        partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, -12.0f, -7.0f, 8.0f, 6.0f, 11.0f, cubeDef), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("Thorax", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -11.0f, 2.0f, 16.0f, 16.0f, 16.0f, cubeDef), PartPose.ZERO);
        PartDefinition RightLeg4 = partdefinition.addOrReplaceChild("RightLeg4", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)17.0f, (float)2.0f));
        RightLeg4.addOrReplaceChild("rightleg4_r1", CubeListBuilder.create().texOffs(48, 12).addBox(-15.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.offset((float)1.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition RightLeg3 = partdefinition.addOrReplaceChild("RightLeg3", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)17.0f, (float)-1.0f));
        RightLeg3.addOrReplaceChild("rightleg3_r1", CubeListBuilder.create().texOffs(48, 8).addBox(-15.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.offset((float)1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition RightLeg2 = partdefinition.addOrReplaceChild("RightLeg2", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)17.0f, (float)-3.0f));
        RightLeg2.addOrReplaceChild("rightleg2_r1", CubeListBuilder.create().texOffs(48, 4).addBox(-15.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.offset((float)1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition RightLeg1 = partdefinition.addOrReplaceChild("RightLeg1", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)17.0f, (float)-5.0f));
        RightLeg1.addOrReplaceChild("rightleg1_r1", CubeListBuilder.create().texOffs(48, 0).addBox(-15.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.offset((float)1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition LeftLeg4 = partdefinition.addOrReplaceChild("LeftLeg4", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)17.0f, (float)2.0f));
        LeftLeg4.addOrReplaceChild("leftleg4_r1", CubeListBuilder.create().texOffs(0, 49).addBox(1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.offset((float)-1.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition LeftLeg3 = partdefinition.addOrReplaceChild("LeftLeg3", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)17.0f, (float)-1.0f));
        LeftLeg3.addOrReplaceChild("leftleg3_r1", CubeListBuilder.create().texOffs(32, 49).addBox(1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.offset((float)-1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition LeftLeg2 = partdefinition.addOrReplaceChild("LeftLeg2", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)17.0f, (float)-3.0f));
        LeftLeg2.addOrReplaceChild("leftleg2_r1", CubeListBuilder.create().texOffs(0, 53).addBox(1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.offset((float)-1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition LeftLeg1 = partdefinition.addOrReplaceChild("LeftLeg1", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)17.0f, (float)-5.0f));
        LeftLeg1.addOrReplaceChild("leftleg1_r1", CubeListBuilder.create().texOffs(32, 53).addBox(1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.offset((float)-1.0f, (float)-1.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void prepareMobModel(EntityPumpkinSpider entityIn, float p_102615_, float p_102616_, float p_102617_) {
        this.LeftLeg3.visible = this.LeftLeg4.visible = entityIn.getProvoked();
        this.LeftLeg2.visible = this.LeftLeg4.visible;
        this.LeftLeg1.visible = this.LeftLeg4.visible;
        this.RightLeg4.visible = this.LeftLeg4.visible;
        this.RightLeg3.visible = this.LeftLeg4.visible;
        this.RightLeg2.visible = this.LeftLeg4.visible;
        this.RightLeg1.visible = this.LeftLeg4.visible;
        this.Head.visible = this.LeftLeg4.visible;
        this.Body.visible = this.LeftLeg4.visible;
    }

    public void setupAnim(EntityPumpkinSpider entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.Thorax.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.25f * limbSwingAmount + 0.2617994f;
        this.Thorax.y = 14.0f;
        this.Thorax.z = -2.0f;
        if (!entity.getProvoked()) {
            this.Thorax.xRot = 1.5707964f;
            this.Thorax.y = 26.0f;
            this.Thorax.z = 3.0f;
        }
        float f = 0.5235988f;
        this.RightLeg2.zRot = this.RightLeg1.zRot = -f;
        this.RightLeg3.zRot = this.RightLeg1.zRot;
        this.RightLeg4.zRot = this.RightLeg1.zRot;
        this.LeftLeg2.zRot = this.LeftLeg1.zRot = f;
        this.LeftLeg3.zRot = this.LeftLeg1.zRot;
        this.LeftLeg4.zRot = this.LeftLeg1.zRot;
        float f1 = f / 2.0f;
        float f2 = f / 6.0f;
        this.RightLeg4.yRot = this.LeftLeg1.yRot = f1;
        this.LeftLeg4.yRot = this.RightLeg1.yRot = -f1;
        this.RightLeg3.yRot = this.LeftLeg2.yRot = f2;
        this.LeftLeg3.yRot = this.RightLeg2.yRot = -f2;
        float g = 0.8662f;
        float h = 0.2f;
        float f3 = -(Mth.cos((float)(limbSwing * g * 2.0f)) * h) * limbSwingAmount;
        float f4 = -(Mth.cos((float)(limbSwing * g * 2.0f + (float)Math.PI)) * h) * limbSwingAmount;
        float f5 = -(Mth.cos((float)(limbSwing * g * 2.0f + 1.5707964f)) * h) * limbSwingAmount;
        float f6 = -(Mth.cos((float)(limbSwing * g * 2.0f + 4.712389f)) * h) * limbSwingAmount;
        float f7 = Mth.abs((float)(Mth.sin((float)(limbSwing * g)) * h)) * limbSwingAmount;
        float f8 = Mth.abs((float)(Mth.sin((float)(limbSwing * g + (float)Math.PI)) * h)) * limbSwingAmount;
        float f9 = Mth.abs((float)(Mth.sin((float)(limbSwing * g + 1.5707964f)) * h)) * limbSwingAmount;
        float f10 = Mth.abs((float)(Mth.sin((float)(limbSwing * g + 4.712389f)) * h)) * limbSwingAmount;
        this.RightLeg4.yRot += f3;
        this.LeftLeg4.yRot -= f3;
        this.RightLeg3.yRot += f4;
        this.LeftLeg3.yRot -= f4;
        this.RightLeg2.yRot += f5;
        this.LeftLeg2.yRot -= f5;
        this.RightLeg1.yRot += f6;
        this.LeftLeg1.yRot -= f6;
        this.RightLeg4.zRot += f7;
        this.LeftLeg4.zRot -= f7;
        this.RightLeg3.zRot += f8;
        this.LeftLeg3.zRot -= f8;
        this.RightLeg2.zRot += f9;
        this.LeftLeg2.zRot -= f9;
        this.RightLeg1.zRot += f10;
        this.LeftLeg1.zRot -= f10;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Thorax.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightLeg4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightLeg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightLeg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightLeg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftLeg4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftLeg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftLeg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftLeg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

