/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.nether.EntityHellSpider;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelHellSpider
extends EntityModel<EntityHellSpider> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("hell_spider");
    private final ModelPart Body;
    private final ModelPart Leg8;
    private final ModelPart Leg6;
    private final ModelPart Leg4;
    private final ModelPart Leg2;
    private final ModelPart Leg7;
    private final ModelPart Leg5;
    private final ModelPart Leg3;
    private final ModelPart Leg1;
    private final ModelPart Head;

    public ModelHellSpider(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Leg8 = root.getChild("Leg8");
        this.Leg6 = root.getChild("Leg6");
        this.Leg4 = root.getChild("Leg4");
        this.Leg2 = root.getChild("Leg2");
        this.Leg7 = root.getChild("Leg7");
        this.Leg5 = root.getChild("Leg5");
        this.Leg3 = root.getChild("Leg3");
        this.Leg1 = root.getChild("Leg1");
        this.Head = root.getChild("Head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 12).mirror().addBox(-5.0f, -4.0f, 3.0f, 10.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        Body.addOrReplaceChild("Shape1_r1", CubeListBuilder.create().texOffs(15, 9).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)14.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("Shape4_r1", CubeListBuilder.create().texOffs(15, 9).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)10.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("Shape2_r1", CubeListBuilder.create().texOffs(15, 9).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)2.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("Shape3_r1", CubeListBuilder.create().texOffs(15, 9).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)6.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("Leg8", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)16.0f, (float)-1.0f, (float)0.0f, (float)0.576f, (float)0.192f));
        partdefinition.addOrReplaceChild("Leg6", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)0.2793f, (float)0.192f));
        partdefinition.addOrReplaceChild("Leg4", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)-0.2793f, (float)0.192f));
        partdefinition.addOrReplaceChild("Leg2", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)16.0f, (float)2.0f, (float)0.0f, (float)-0.576f, (float)0.192f));
        partdefinition.addOrReplaceChild("Leg7", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)16.0f, (float)-1.0f, (float)0.0f, (float)-0.576f, (float)-0.192f));
        partdefinition.addOrReplaceChild("Leg5", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)-0.2793f, (float)-0.192f));
        partdefinition.addOrReplaceChild("Leg3", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)0.2793f, (float)-0.192f));
        partdefinition.addOrReplaceChild("Leg1", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)16.0f, (float)2.0f, (float)0.0f, (float)0.576f, (float)-0.192f));
        partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(32, 16).mirror().addBox(4.0f, -6.0f, -2.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(32, 16).mirror().addBox(-5.0f, -6.0f, -2.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(32, 4).mirror().addBox(-5.0f, -8.0f, -8.0f, 1.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(32, 4).mirror().addBox(4.0f, -8.0f, -8.0f, 1.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(32, 4).mirror().addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)16.0f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(EntityHellSpider entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        float var8 = 0.7853982f;
        this.Leg1.zRot = -var8;
        this.Leg2.zRot = var8;
        this.Leg3.zRot = -var8 * 0.74f;
        this.Leg4.zRot = var8 * 0.74f;
        this.Leg5.zRot = -var8 * 0.74f;
        this.Leg6.zRot = var8 * 0.74f;
        this.Leg7.zRot = -var8;
        this.Leg8.zRot = var8;
        float var9 = -0.0f;
        float var10 = 0.3926991f;
        this.Leg1.yRot = var10 * 2.0f + var9;
        this.Leg2.yRot = -var10 * 2.0f - var9;
        this.Leg3.yRot = var10 * 1.0f + var9;
        this.Leg4.yRot = -var10 * 1.0f - var9;
        this.Leg5.yRot = -var10 * 1.0f + var9;
        this.Leg6.yRot = var10 * 1.0f - var9;
        this.Leg7.yRot = -var10 * 2.0f + var9;
        this.Leg8.yRot = var10 * 2.0f - var9;
        float var11 = (float)(-(Math.cos(limbSwing * 0.6662f * 2.0f + 0.0f) * (double)0.4f) * (double)limbSwingAmount);
        float var12 = (float)(-(Math.cos((double)(limbSwing * 0.6662f * 2.0f) + Math.PI) * (double)0.4f) * (double)limbSwingAmount);
        float var13 = (float)(-(Math.cos((double)(limbSwing * 0.6662f * 2.0f) + 1.5707963267948966) * (double)0.4f) * (double)limbSwingAmount);
        float var14 = (float)(-(Math.cos((double)(limbSwing * 0.6662f * 2.0f) + 4.71238898038469) * (double)0.4f) * (double)limbSwingAmount);
        float var15 = (float)(Math.abs(Math.sin(limbSwing * 0.6662f + 0.0f) * (double)0.4f) * (double)limbSwingAmount);
        float var16 = (float)(Math.abs(Math.sin((double)(limbSwing * 0.6662f) + Math.PI) * (double)0.4f) * (double)limbSwingAmount);
        float var17 = (float)(Math.abs(Math.sin((double)(limbSwing * 0.6662f) + 1.5707963267948966) * (double)0.4f) * (double)limbSwingAmount);
        float var18 = (float)(Math.abs(Math.sin((double)(limbSwing * 0.6662f) + 4.71238898038469) * (double)0.4f) * (double)limbSwingAmount);
        this.Leg1.yRot += var11;
        this.Leg2.yRot += -var11;
        this.Leg3.yRot += var12;
        this.Leg4.yRot += -var12;
        this.Leg5.yRot += var13;
        this.Leg6.yRot += -var13;
        this.Leg7.yRot += var14;
        this.Leg8.yRot += -var14;
        this.Leg1.zRot += var15;
        this.Leg2.zRot += -var15;
        this.Leg3.zRot += var16;
        this.Leg4.zRot += -var16;
        this.Leg5.zRot += var17;
        this.Leg6.zRot += -var17;
        this.Leg7.zRot += var18;
        this.Leg8.zRot += -var18;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg8.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg6.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg7.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg5.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

