/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelHellPig
extends EntityModel<EntityDivineTameable> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("hell_pig");
    public final ModelPart Body;
    public final ModelPart Head;
    public final ModelPart LeftEar;
    public final ModelPart RightEar;
    public final ModelPart BackRightLeg;
    public final ModelPart BackLeftLeg;
    public final ModelPart FrontRightLeg;
    public final ModelPart FrontLeftLeg;

    public ModelHellPig(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Head = this.Body.getChild("Head");
        this.LeftEar = this.Head.getChild("LeftEar");
        this.RightEar = this.Head.getChild("RightEar");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 50).addBox(-8.0f, -3.0f, 1.99f, 10.0f, 8.0f, 0.0f, cubeDef).texOffs(0, 0).addBox(-8.0f, -3.0f, 2.0f, 10.0f, 9.0f, 14.0f, cubeDef), PartPose.offset((float)3.0f, (float)9.0f, (float)-9.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 23).addBox(-4.0f, -5.0f, -6.0f, 8.0f, 8.0f, 6.0f, cubeDef).texOffs(12, 37).addBox(-2.5f, -1.0f, -6.99f, 5.0f, 3.0f, 1.0f, cubeDef).texOffs(-1, 52).addBox(0.0f, -10.0f, -7.0f, 0.0f, 5.0f, 7.0f, cubeDef), PartPose.offset((float)-3.0f, (float)0.5f, (float)2.01f));
        Head.addOrReplaceChild("RightEar", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -2.0f, 1.0f, 7.0f, 4.0f, cubeDef), PartPose.offset((float)-4.0f, (float)-3.0f, (float)-3.0f));
        Head.addOrReplaceChild("LeftEar", CubeListBuilder.create().texOffs(40, 32).addBox(0.0f, 0.0f, -2.0f, 1.0f, 7.0f, 4.0f, cubeDef), PartPose.offset((float)4.0f, (float)-3.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(28, 23).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, cubeDef), PartPose.offset((float)-2.99f, (float)14.99f, (float)4.99f));
        partdefinition.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(34, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, cubeDef), PartPose.offset((float)2.99f, (float)14.99f, (float)4.99f));
        partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(0, 37).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, cubeDef), PartPose.offset((float)-2.99f, (float)14.99f, (float)-4.99f));
        partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(24, 36).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, cubeDef), PartPose.offset((float)2.99f, (float)14.99f, (float)-4.99f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityDivineTameable entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        float f1 = ageInTicks * 0.1f + limbSwing * 0.5f;
        float f2 = 0.08f + limbSwingAmount * 0.4f;
        this.RightEar.zRot = 0.2617994f + Mth.cos((float)f1) * f2;
        this.LeftEar.zRot = -0.2617994f - Mth.cos((float)(f1 * 1.2f)) * f2;
        float f3 = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f4 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.Body.zRot = f3 * 0.04f;
        this.BackRightLeg.xRot = this.FrontLeftLeg.xRot = f3;
        this.BackLeftLeg.xRot = this.FrontRightLeg.xRot = f4;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

