/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityEnthralledDramcryx;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelEnthralledDramcryx
extends EntityModel<EntityEnthralledDramcryx> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("enthralled_dramcryx");
    public final ModelPart Body;
    public final ModelPart Tail;
    public final ModelPart Head;
    public final ModelPart BackRightLeg;
    public final ModelPart FrontLeftLeg;
    public final ModelPart FrontRightLeg;
    public final ModelPart BackLeftLeg;

    public ModelEnthralledDramcryx(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Tail = this.Body.getChild("Tail");
        this.Head = this.Body.getChild("Head");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)15.0f, (float)2.0f));
        Body.addOrReplaceChild("Body_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -7.0f, -19.0f, 14.0f, 8.0f, 20.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)8.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Spines = Body.addOrReplaceChild("Spines", CubeListBuilder.create().texOffs(40, 28).addBox(-1.0f, -17.0f, -6.5f, 5.0f, 16.0f, 6.0f, cubeDef), PartPose.offset((float)-1.5f, (float)-4.0f, (float)0.5f));
        Spines.addOrReplaceChild("BackSpine_r1", CubeListBuilder.create().texOffs(66, 43).addBox(-1.0f, -18.03f, -6.94f, 3.0f, 10.0f, 3.0f, cubeDef), PartPose.offsetAndRotation((float)1.0f, (float)7.0f, (float)-3.5f, (float)-1.0908f, (float)0.0f, (float)0.0f));
        Spines.addOrReplaceChild("MiddleSpine_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-2.01f, -22.54f, -2.29f, 5.0f, 14.0f, 4.0f, cubeDef), PartPose.offsetAndRotation((float)1.0f, (float)7.0f, (float)-3.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(62, 28).addBox(-4.0f, -8.0f, -2.5f, 8.0f, 10.0f, 5.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)11.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(4, 28).addBox(4.99f, -1.0f, -10.5f, 1.0f, 5.0f, 1.0f, cubeDef).texOffs(0, 28).addBox(-5.99f, -1.0f, -10.5f, 1.0f, 5.0f, 1.0f, cubeDef).texOffs(0, 28).addBox(-6.0f, -5.0f, -8.0f, 12.0f, 10.0f, 8.0f, cubeDef).texOffs(0, 65).addBox(-5.0f, -2.0f, -10.0f, 10.0f, 7.0f, 2.0f, cubeDef).texOffs(32, 28).addBox(1.0f, -8.0f, -4.2f, 4.0f, 3.0f, 3.0f, cubeDef).texOffs(66, 0).addBox(-5.0f, -8.0f, -4.2f, 4.0f, 3.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)-6.0f, (float)-9.0f));
        partdefinition.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(0, 46).addBox(-4.0f, -3.0f, -3.0f, 6.0f, 13.0f, 6.0f, cubeDef), PartPose.offset((float)-5.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(48, 50).addBox(-2.0f, -3.0f, -3.0f, 6.0f, 13.0f, 6.0f, cubeDef), PartPose.offset((float)4.0f, (float)14.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(24, 50).addBox(-4.0f, -3.0f, -3.0f, 6.0f, 13.0f, 6.0f, cubeDef), PartPose.offset((float)-4.0f, (float)14.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(48, 0).addBox(-2.0f, -3.0f, -3.0f, 6.0f, 13.0f, 6.0f, cubeDef), PartPose.offset((float)5.0f, (float)14.0f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityEnthralledDramcryx entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.Body.zRot = f * 0.05f;
        this.Tail.yRot = f * 0.25f;
        this.FrontRightLeg.xRot = this.BackLeftLeg.xRot = f1;
        this.FrontLeftLeg.xRot = this.BackRightLeg.xRot = f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

