/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.end.EntityEnderScrounge;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelEnderScrounge
extends EntityModel<EntityEnderScrounge> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("ender_scrounge");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart frontleft;
    private final ModelPart frontright;
    private final ModelPart backleft;
    private final ModelPart backright;
    private final ModelPart tail;

    public ModelEnderScrounge(ModelPart root) {
        this.body = root.getChild("body");
        this.tail = this.body.getChild("tail");
        this.head = root.getChild("head");
        this.frontleft = root.getChild("frontleft");
        this.frontright = root.getChild("frontright");
        this.backleft = root.getChild("backleft");
        this.backright = root.getChild("backright");
    }

    public ModelEnderScrounge(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.tail = this.body.getChild("tail");
        this.head = root.getChild("head");
        this.frontleft = root.getChild("frontleft");
        this.frontright = root.getChild("frontright");
        this.backleft = root.getChild("backleft");
        this.backright = root.getChild("backright");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -3.0f, 4.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.0f, (float)-1.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(22, -4).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)4.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 10).addBox(-2.0f, -2.0f, -3.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(22, 3).addBox(1.0f, -4.0f, -2.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(22, 3).addBox(-4.0f, -4.0f, -2.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 12).addBox(-1.0f, -0.1f, -5.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(12, 11).addBox(-0.5f, -0.3f, -5.2f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("frontleft", CubeListBuilder.create().texOffs(12, 11).addBox(0.0f, 1.0f, -2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(0.0f, -1.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)22.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("frontright", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(12, 11).addBox(-1.0f, 1.0f, -2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)22.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("backleft", CubeListBuilder.create().texOffs(14, 10).addBox(0.0f, -1.0f, -2.0f, 1.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(12, 11).addBox(0.0f, 2.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)21.0f, (float)2.0f));
        partdefinition.addOrReplaceChild("backright", CubeListBuilder.create().texOffs(12, 11).addBox(-1.0f, 2.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(14, 10).addBox(-1.0f, -1.0f, -2.0f, 1.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)21.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public void setupAnim(EntityEnderScrounge entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.frontleft.xRot = this.backright.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.frontright.xRot = this.backleft.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.tail.zRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)limbSwingAmount);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.frontleft.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.frontright.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.backleft.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.backright.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

