/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityDesertCrawler;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelDesertCrawler
extends EntityModel<EntityDesertCrawler> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("desert_crawler");
    public final ModelPart body;
    public final ModelPart bb_main;
    public final ModelPart head;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart rightArm;
    public final ModelPart leftArm;

    public ModelDesertCrawler(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.bb_main = root.getChild("bb_main");
        this.head = root.getChild("head");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
        this.rightArm = root.getChild("right_arm");
        this.leftArm = root.getChild("left_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -4.0f, 8.0f, 6.0f, 17.0f, cubeDef), PartPose.offset((float)-1.0f, (float)14.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(40, 23).addBox(-4.0f, -14.0f, -11.0f, 8.0f, 9.0f, 2.0f, cubeDef), PartPose.offset((float)0.01f, (float)24.0f, (float)2.01f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 23).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef).texOffs(24, 18).addBox(-4.0f, -8.0f, -1.0f, 0.0f, 4.0f, 5.0f, cubeDef).texOffs(30, 18).addBox(-4.01f, -8.0f, -1.0f, 0.0f, 4.0f, 5.0f, cubeDef).texOffs(44, 46).addBox(4.0f, 1.0f, -6.0f, 1.0f, 3.0f, 6.0f, cubeDef).texOffs(42, 37).addBox(-5.0f, 1.0f, -6.0f, 1.0f, 3.0f, 6.0f, cubeDef).texOffs(24, 22).addBox(4.0f, -8.0f, -1.0f, 0.0f, 4.0f, 5.0f, cubeDef).texOffs(30, 22).addBox(4.01f, -8.0f, -1.0f, 0.0f, 4.0f, 5.0f, cubeDef), PartPose.offset((float)0.01f, (float)6.01f, (float)-8.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(24, 31).addBox(-4.0f, -2.0f, -2.0f, 4.0f, 4.0f, 8.0f, cubeDef).texOffs(16, 43).addBox(-5.0f, 2.0f, 3.0f, 4.0f, 7.0f, 3.0f, cubeDef), PartPose.offset((float)-2.5f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(33, 0).addBox(0.0f, -2.0f, -2.0f, 4.0f, 4.0f, 8.0f, cubeDef).texOffs(30, 43).addBox(1.0f, 2.0f, 3.0f, 4.0f, 7.0f, 3.0f, cubeDef), PartPose.offset((float)2.5f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.offset((float)-3.99f, (float)14.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 39).addBox(0.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.offset((float)3.99f, (float)14.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityDesertCrawler entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        if (!entity.isAggressive()) {
            this.body.z = -4.0f;
            this.body.zRot = 0.0f;
            this.body.xRot = 5.6089997f;
            this.leftLeg.y = 18.0f;
            this.rightLeg.y = 18.0f;
            this.leftLeg.z = 4.0f;
            this.rightLeg.z = 4.0f;
            this.leftLeg.xRot = 4.712389f;
            this.rightLeg.xRot = 4.712389f;
            this.leftArm.xRot = 5.812f;
            this.rightArm.xRot = 5.812f;
        } else {
            float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.body.z = -3.0f;
            this.body.zRot = f * 0.05f;
            this.body.xRot = (float)Math.PI * 8;
            this.leftLeg.y = 15.0f;
            this.rightLeg.y = 15.0f;
            this.leftLeg.z = 5.0f;
            this.rightLeg.z = 5.0f;
            this.leftArm.xRot = this.rightArm.xRot = f;
            this.leftLeg.xRot = this.rightLeg.xRot = f1;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.bb_main.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

