/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityAridWarrior;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;

public class ModelAridWarrior
extends HumanoidModel<EntityAridWarrior> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("arid_warrior");
    public final ModelPart rightEar;
    public final ModelPart leftEar;
    public final ModelPart cloak;

    public ModelAridWarrior(ModelPart part) {
        super(part);
        this.rightEar = this.head.getChild("right_ear");
        this.leftEar = this.head.getChild("left_ear");
        this.cloak = this.body.getChild("cloak");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartPose zPose = PartPose.ZERO;
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef), zPose);
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(29, 46).addBox(0.0f, -5.0f, 0.0f, 0.0f, 6.0f, 6.0f, cubeDef), PartPose.offset((float)-4.0f, (float)-7.0f, (float)-1.0f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(41, 46).addBox(0.0f, -5.0f, 0.0f, 0.0f, 6.0f, 6.0f, cubeDef), PartPose.offset((float)4.0f, (float)-7.0f, (float)-1.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-5.0f, -10.0f, -3.0f, 10.0f, 10.0f, 6.0f, cubeDef), zPose);
        body.addOrReplaceChild("hip", CubeListBuilder.create().texOffs(27, 11).addBox(-5.0f, 0.0f, -2.0f, 10.0f, 4.0f, 5.0f, cubeDef), zPose);
        body.addOrReplaceChild("cloak", CubeListBuilder.create().texOffs(31, 31).addBox(-5.0f, 0.0f, 0.0f, 10.0f, 20.0f, 1.0f, cubeDef), PartPose.offset((float)0.0f, (float)-10.0f, (float)3.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(12, 32).addBox(-2.0f, -1.0f, -1.5f, 3.0f, 14.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)0.5f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 32).addBox(-1.0f, -1.0f, -1.5f, 3.0f, 14.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)0.5f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(48, 0).addBox(-2.5f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDef), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        rightLeg.addOrReplaceChild("right_foot", CubeListBuilder.create().texOffs(32, 20).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, cubeDef), PartPose.offset((float)-1.0f, (float)4.99f, (float)1.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(48, 20).addBox(-1.5f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDef), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        leftLeg.addOrReplaceChild("left_foot", CubeListBuilder.create().texOffs(32, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, cubeDef), PartPose.offset((float)1.0f, (float)4.99f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(EntityAridWarrior entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.rightArmPose = this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        if (entity.getMainHandItem().getItem() instanceof BowItem && entity.isAggressive()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.prepareMobModel((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks);
    }

    public void setupAnim(EntityAridWarrior entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float f = 0.19634955f + Mth.cos((float)(ageInTicks * 0.05f + limbSwing * 0.5f)) * 0.08f + limbSwingAmount * 0.1f + 0.2182f;
        this.rightEar.yRot = -f;
        this.leftEar.yRot = f;
        float cloakMov = Mth.sqrt((float)((float)Math.atan(200.0f * limbSwing))) * limbSwingAmount;
        this.cloak.xRot = cloakMov + 0.17453294f;
        this.leftArm.y = -1.0f;
        this.rightArm.y = -1.0f;
        this.rightArm.x = -6.0f;
        this.leftArm.x = 6.0f;
        this.leftLeg.y = 12.0f;
        this.rightLeg.y = 12.0f;
        this.hat.y = -1.99f;
        this.head.y = -1.99f;
        this.body.y = 8.0f;
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelpart = this.getArm(arm);
        modelpart.x += f;
        modelpart.translateAndRotate(stack);
        modelpart.x -= f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

