/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelSunArcher<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("sun_archer");
    private final ModelPart legRight;
    private final ModelPart legLeft;
    private final ModelPart body;
    private final ModelPart footRight;
    private final ModelPart footLeft;
    private final ModelPart spine1;
    private final ModelPart spine2;
    private final ModelPart spine3;
    private final ModelPart spine4;
    private final ModelPart spine5;
    private final ModelPart head;
    public final ModelPart armRight;
    private final ModelPart armBandRight;
    private final ModelPart armLeft;
    private final ModelPart armBandLeft;

    public ModelSunArcher(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.legRight = root.getChild("legRight");
        this.legLeft = root.getChild("legLeft");
        this.body = root.getChild("body");
        this.footRight = root.getChild("footRight");
        this.footLeft = root.getChild("footLeft");
        this.spine1 = root.getChild("spine1");
        this.spine2 = root.getChild("spine2");
        this.spine3 = root.getChild("spine3");
        this.spine4 = root.getChild("spine4");
        this.spine5 = root.getChild("spine5");
        this.head = root.getChild("head");
        this.armRight = root.getChild("armRight");
        this.armBandRight = root.getChild("armBandRight");
        this.armLeft = root.getChild("armLeft");
        this.armBandLeft = root.getChild("armBandLeft");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)11.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)11.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 43).mirror().addBox(0.0f, 0.0f, 0.0f, 12.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-6.0f, (float)-5.0f, (float)-1.5f));
        partdefinition.addOrReplaceChild("footRight", CubeListBuilder.create().texOffs(0, 15).mirror().addBox(-1.5f, 12.0f, -2.5f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)11.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("footLeft", CubeListBuilder.create().texOffs(0, 15).mirror().addBox(-1.5f, 12.0f, -2.5f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)11.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("spine1", CubeListBuilder.create().texOffs(8, 0).mirror().addBox(0.0f, -4.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)0.0f, (float)2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("spine2", CubeListBuilder.create().texOffs(8, 0).mirror().addBox(0.0f, -4.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)3.0f, (float)2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("spine3", CubeListBuilder.create().texOffs(8, 0).mirror().addBox(0.0f, -4.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)6.0f, (float)2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("spine4", CubeListBuilder.create().texOffs(8, 0).mirror().addBox(0.0f, -4.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)9.0f, (float)2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("spine5", CubeListBuilder.create().texOffs(8, 0).mirror().addBox(0.0f, -4.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)-3.0f, (float)2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 31).mirror().addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("armRight", CubeListBuilder.create().texOffs(16, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-7.0f, (float)-4.0f, (float)1.0f, (float)-1.309f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("armBandRight", CubeListBuilder.create().texOffs(24, 0).mirror().addBox(-1.5f, 3.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-7.0f, (float)-4.0f, (float)1.0f, (float)-1.309f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("armLeft", CubeListBuilder.create().texOffs(16, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.5f, (float)-4.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        partdefinition.addOrReplaceChild("armBandLeft", CubeListBuilder.create().texOffs(24, 0).mirror().addBox(-1.5f, 3.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.5f, (float)-4.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.legLeft.xRot = this.footLeft.xRot = Mth.cos((float)limbSwing) * limbSwingAmount;
        this.legRight.xRot = this.footRight.xRot = Mth.cos((float)(limbSwing + (float)Math.PI)) * limbSwingAmount;
        this.armRight.xRot = this.armBandRight.xRot = -1.308997f + Mth.cos((float)limbSwing) * limbSwingAmount * 0.3f;
        this.armLeft.xRot = this.armBandLeft.xRot = Mth.cos((float)limbSwing) * limbSwingAmount;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.legRight.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.legLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.footRight.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.footLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.spine1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.spine2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.spine3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.spine4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.spine5.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.armRight.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.armBandRight.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.armLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.armBandLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

