/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.eden.EntityGreenfeet;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class ModelGreenfeet
extends EntityModel<EntityGreenfeet> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("greenfeet");
    public final ModelPart Body;
    public final ModelPart Head;
    public final ModelPart RightArm;
    public final ModelPart LeftArm;
    public final ModelPart RightLeg;
    public final ModelPart LeftLeg;

    public ModelGreenfeet(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Head = this.Body.getChild("Head");
        this.RightArm = this.Body.getChild("RightArm");
        this.LeftArm = this.Body.getChild("LeftArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.5f));
        Body.addOrReplaceChild("Chest_r1", CubeListBuilder.create().texOffs(0, 30).addBox(-4.5f, -12.0f, -1.5f, 9.0f, 14.0f, 5.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-12.0f, (float)-3.5f));
        Head.addOrReplaceChild("skull_r1", CubeListBuilder.create().texOffs(28, 30).addBox(-2.5f, -10.0f, -3.0f, 5.0f, 12.0f, 4.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-3.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = Body.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(28, 0).addBox(-2.0f, -1.0f, -2.0f, 2.0f, 8.0f, 3.0f, cubeDef), PartPose.offset((float)-4.5f, (float)-11.0f, (float)-2.5f));
        RightArm.addOrReplaceChild("RightBlade", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.0f, -7.0f, 2.0f, 2.0f, 10.0f, cubeDef).texOffs(0, 0).addBox(-1.0f, 0.0f, -13.0f, 0.0f, 6.0f, 18.0f, cubeDef), PartPose.offset((float)-0.5f, (float)8.0f, (float)-1.0f));
        PartDefinition LeftArm = Body.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(25, 46).addBox(0.0f, -1.0f, -2.0f, 2.0f, 8.0f, 3.0f, cubeDef), PartPose.offset((float)4.5f, (float)-11.0f, (float)-2.5f));
        LeftArm.addOrReplaceChild("LeftBlade", CubeListBuilder.create().texOffs(14, 2).addBox(-1.5f, 0.0f, -7.0f, 2.0f, 2.0f, 10.0f, cubeDef).texOffs(0, 6).addBox(0.0f, 1.0f, -13.0f, 0.0f, 6.0f, 18.0f, cubeDef), PartPose.offset((float)1.5f, (float)7.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(42, 42).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.offset((float)-3.0f, (float)12.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(36, 10).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.offset((float)3.0f, (float)12.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityGreenfeet entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180) - 0.5672f;
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.Body.zRot = f * 0.05f;
        this.RightArm.xRot = f1;
        this.LeftArm.xRot = f;
        this.LeftArm.zRot = 0.0f;
        this.RightArm.zRot = 0.0f;
        this.LeftArm.yRot = 0.0f;
        this.RightArm.yRot = 0.0f;
        AnimationUtils.bobModelPart((ModelPart)this.RightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.bobModelPart((ModelPart)this.LeftArm, (float)ageInTicks, (float)-1.0f);
        this.RightLeg.xRot = f * 1.4f;
        this.LeftLeg.xRot = f1 * 1.4f;
        this.setupAttackAnimation(entity, ageInTicks);
    }

    protected ModelPart getArm(HumanoidArm humanoidarm) {
        return this.RightArm;
    }

    private HumanoidArm getAttackArm(EntityGreenfeet entity) {
        return entity.getMainArm();
    }

    protected void setupAttackAnimation(EntityGreenfeet entity, float ageInTicks) {
        if (!(this.attackTime <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm(entity);
            ModelPart modelpart = this.getArm(humanoidarm);
            float f = this.attackTime;
            this.Body.yRot = Mth.sin((float)(Mth.sqrt((float)f) * (float)Math.PI * 2.0f)) * 0.2f;
            this.RightArm.yRot += this.Body.yRot;
            f = 1.0f - this.attackTime;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.sin((float)(f * (float)Math.PI));
            float f2 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.Head.xRot - 0.7f) * 0.75f;
            modelpart.xRot -= f1 * 1.2f + f2;
            modelpart.yRot += this.Body.yRot * 2.0f;
            modelpart.zRot += Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

