/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.base.EntityBaseCadillion;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelCadillion
extends EntityModel<EntityBaseCadillion> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("cadillion");
    public final ModelPart Body;
    public final ModelPart Head;
    public final ModelPart RightEar;
    public final ModelPart LeftEar;
    public final ModelPart FrontRightLeg;
    public final ModelPart FrontLeftLeg;
    public final ModelPart BackRightLeg;
    public final ModelPart BackLeftLeg;

    public ModelCadillion(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Head = this.Body.getChild("Head");
        this.RightEar = this.Head.getChild("RightEar");
        this.LeftEar = this.Head.getChild("LeftEar");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 31).addBox(-4.0f, -4.5f, -8.75f, 8.0f, 8.0f, 17.0f, cubeDef).texOffs(0, 0).addBox(-5.5f, -5.5f, -9.25f, 11.0f, 12.0f, 19.0f, cubeDef), PartPose.offset((float)0.0f, (float)9.5f, (float)0.75f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(33, 33).addBox(-4.0f, -5.8f, -5.7f, 8.0f, 8.0f, 6.0f, cubeDef).texOffs(54, 12).addBox(-3.0f, -2.8f, -8.7f, 6.0f, 4.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)-3.7f, (float)-9.04f));
        Head.addOrReplaceChild("Horn_r1", CubeListBuilder.create().texOffs(14, 56).addBox(-1.0f, -7.5f, -1.0f, 2.0f, 7.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)-3.7528f, (float)-4.4743f, (float)0.3927f, (float)0.0f, (float)0.0f));
        Head.addOrReplaceChild("RightEar", CubeListBuilder.create().texOffs(55, 31).addBox(-5.5f, -6.47f, 1.0f, 6.0f, 7.0f, 0.0f, cubeDef).texOffs(38, 56).addBox(-5.5f, -6.47f, 0.99f, 6.0f, 7.0f, 0.0f, cubeDef), PartPose.offsetAndRotation((float)-2.5f, (float)-2.8f, (float)-1.7f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        Head.addOrReplaceChild("LeftEar", CubeListBuilder.create().texOffs(1, 56).addBox(-0.5f, -7.0f, 1.0f, 6.0f, 7.0f, 0.0f, cubeDef).texOffs(22, 56).addBox(-0.5f, -7.0f, 0.99f, 6.0f, 7.0f, 0.0f, cubeDef), PartPose.offsetAndRotation((float)2.5f, (float)-2.8f, (float)-1.7f, (float)0.0f, (float)0.0f, (float)0.1309f));
        Head.addOrReplaceChild("Mouth", CubeListBuilder.create().texOffs(0, 15).addBox(-3.0f, -0.5f, -1.5f, 6.0f, 1.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)1.7f, (float)-7.2f));
        partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(50, 50).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, cubeDef), PartPose.offset((float)-3.0f, (float)12.99f, (float)-6.01f));
        partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(41, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, cubeDef), PartPose.offset((float)3.0f, (float)12.99f, (float)-6.01f));
        partdefinition.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, cubeDef), PartPose.offset((float)-3.0f, (float)12.99f, (float)8.0f));
        partdefinition.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(0, 31).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, cubeDef), PartPose.offset((float)3.0f, (float)12.99f, (float)8.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityBaseCadillion entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        float f2 = 0.19634955f + Mth.cos((float)(ageInTicks * 0.06f + limbSwing * 0.05f)) * 0.08f + limbSwingAmount * 0.2f;
        this.Body.zRot = f * 0.05f;
        this.RightEar.yRot = -f2;
        this.LeftEar.yRot = f2;
        this.BackRightLeg.xRot = this.FrontLeftLeg.xRot = f;
        this.BackLeftLeg.xRot = this.FrontRightLeg.xRot = f1;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

