/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.apalachia.EntityApalachiaTomo;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelApalachiaTomo
extends EntityModel<EntityApalachiaTomo> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("apalachia_tomo");
    public final ModelPart Torso;
    public final ModelPart RightAntenna;
    public final ModelPart LeftAntenna;
    public final ModelPart RightArm;
    public final ModelPart LeftArm;
    public final ModelPart RightFoot;
    public final ModelPart LeftFoot;

    public ModelApalachiaTomo(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Torso = root.getChild("Torso");
        this.RightAntenna = this.Torso.getChild("RightAntenna");
        this.LeftAntenna = this.Torso.getChild("LeftAntenna");
        this.RightArm = this.Torso.getChild("RightArm");
        this.LeftArm = this.Torso.getChild("LeftArm");
        this.RightFoot = root.getChild("RightFoot");
        this.LeftFoot = root.getChild("LeftFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Torso = partdefinition.addOrReplaceChild("Torso", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -7.0f, -4.0f, 12.0f, 8.0f, 9.0f, cubeDef).texOffs(0, 17).addBox(-6.0f, -7.0f, -5.0f, 12.0f, 8.0f, 1.0f, cubeDef), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        Torso.addOrReplaceChild("RightAntenna", CubeListBuilder.create().texOffs(37, 37).addBox(-1.5f, -6.5f, -3.0f, 3.0f, 3.0f, 3.0f, cubeDef).texOffs(28, 32).addBox(-1.5f, -5.0f, -1.5f, 3.0f, 5.0f, 3.0f, cubeDef).texOffs(38, 20).addBox(-2.0f, -7.0f, -2.5f, 4.0f, 4.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)-2.5f, (float)-6.0f, (float)0.0f, (float)0.0873f, (float)0.1745f, (float)0.0f));
        Torso.addOrReplaceChild("LeftAntenna", CubeListBuilder.create().texOffs(37, 29).addBox(-1.5f, -6.5f, -3.0f, 3.0f, 3.0f, 3.0f, cubeDef).texOffs(16, 32).addBox(-1.5f, -5.0f, -1.5f, 3.0f, 5.0f, 3.0f, cubeDef).texOffs(0, 36).addBox(-2.0f, -7.0f, -2.5f, 4.0f, 4.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)2.5f, (float)-6.0f, (float)0.0f, (float)0.0873f, (float)-0.1745f, (float)0.0f));
        PartDefinition RightArm = Torso.addOrReplaceChild("RightArm", CubeListBuilder.create(), PartPose.offset((float)-6.0f, (float)-5.0f, (float)-0.5f));
        RightArm.addOrReplaceChild("RightArm_r1", CubeListBuilder.create().texOffs(33, 0).addBox(-4.0f, -1.0f, -1.5f, 4.0f, 2.0f, 3.0f, cubeDef), PartPose.ZERO);
        PartDefinition LeftArm = Torso.addOrReplaceChild("LeftArm", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)-5.0f, (float)-0.5f));
        LeftArm.addOrReplaceChild("LeftArm_r1", CubeListBuilder.create().texOffs(26, 17).addBox(0.0f, -1.0f, -1.5f, 4.0f, 2.0f, 3.0f, cubeDef), PartPose.ZERO);
        partdefinition.addOrReplaceChild("RightFoot", CubeListBuilder.create().texOffs(22, 22).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 6.0f, 4.0f, cubeDef), PartPose.offset((float)-3.0f, (float)18.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("LeftFoot", CubeListBuilder.create().texOffs(0, 26).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 6.0f, 4.0f, cubeDef), PartPose.offset((float)3.0f, (float)18.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityApalachiaTomo entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = Mth.cos((float)(ageInTicks * 0.12f + limbSwing * 0.6f)) * (0.08f + limbSwingAmount * 0.4f);
        float f1 = Mth.cos((float)(ageInTicks * 0.1f + limbSwing * 0.5f)) * (0.08f + limbSwingAmount * 0.4f);
        float f2 = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.Torso.zRot = f2 * 0.8f;
        this.RightAntenna.zRot = -0.19634955f - f;
        this.LeftAntenna.zRot = 0.19634955f + f1;
        this.RightArm.zRot = 0.5235988f + f1 - 0.5f;
        this.LeftArm.zRot = -0.5235988f - f + 0.5f;
        this.RightFoot.xRot = f2 * 0.7f;
        this.LeftFoot.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.7f * limbSwingAmount;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightFoot.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftFoot.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

