/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.mortum.EntityAngryGlinthop;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelAngryGlinthop
extends EntityModel<EntityAngryGlinthop> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("angry_glinthop");
    public final ModelPart Spine;
    public final ModelPart Body;
    public final ModelPart Skull;
    public final ModelPart RightWhisker;
    public final ModelPart LeftWhisker;
    public final ModelPart RightEar;
    public final ModelPart LeftEar;
    public final ModelPart Tail;
    public final ModelPart BackRightLeg;
    public final ModelPart BackLeftLeg;
    public final ModelPart FrontRightLeg;
    public final ModelPart FrontLeftLeg;

    public ModelAngryGlinthop(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Spine = root.getChild("Spine");
        this.Body = this.Spine.getChild("Body");
        this.Skull = this.Body.getChild("Skull");
        this.RightWhisker = this.Skull.getChild("RightWhisker");
        this.LeftWhisker = this.Skull.getChild("LeftWhisker");
        this.RightEar = this.Skull.getChild("RightEar");
        this.LeftEar = this.Skull.getChild("LeftEar");
        this.Tail = this.Body.getChild("Tail");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Spine = partdefinition.addOrReplaceChild("Spine", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Body = Spine.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(46, 28).addBox(-11.0f, -29.0f, -5.0f, 22.0f, 21.0f, 0.0f, cubeDef).texOffs(0, 0).addBox(-5.0f, -23.0f, -8.0f, 10.0f, 11.0f, 17.0f, cubeDef).texOffs(0, 28).addBox(-7.0f, -25.0f, -12.0f, 14.0f, 15.0f, 9.0f, cubeDef), PartPose.ZERO);
        PartDefinition Skull = Body.addOrReplaceChild("Skull", CubeListBuilder.create().texOffs(0, 33).addBox(-1.0f, -2.0f, -9.0f, 2.0f, 2.0f, 2.0f, cubeDef).texOffs(38, 49).addBox(-5.0f, -8.0f, -8.0f, 10.0f, 12.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)-18.0f, (float)-11.99f));
        Skull.addOrReplaceChild("RightWhisker", CubeListBuilder.create().texOffs(54, 18).addBox(-8.5f, -4.5f, 0.0f, 9.0f, 9.0f, 0.0f, cubeDef), PartPose.offset((float)-5.5f, (float)-0.5f, (float)-7.0f));
        Skull.addOrReplaceChild("LeftWhisker", CubeListBuilder.create().texOffs(71, 0).addBox(-0.5f, -4.5f, 0.0f, 9.0f, 9.0f, 0.0f, cubeDef), PartPose.offset((float)5.5f, (float)-0.5f, (float)-7.0f));
        Skull.addOrReplaceChild("RightEar", CubeListBuilder.create().texOffs(24, 52).addBox(-2.5f, -5.5f, -0.5f, 4.0f, 5.0f, 2.0f, cubeDef).texOffs(0, 28).addBox(-3.5f, -7.5f, 1.5f, 4.0f, 5.0f, 0.0f, cubeDef), PartPose.offset((float)-2.5f, (float)-7.5f, (float)-1.51f));
        Skull.addOrReplaceChild("LeftEar", CubeListBuilder.create().texOffs(37, 28).addBox(-0.5f, -7.5f, 1.5f, 4.0f, 5.0f, 0.0f, cubeDef).texOffs(66, 49).addBox(-1.5f, -5.5f, -0.5f, 4.0f, 5.0f, 2.0f, cubeDef), PartPose.offset((float)2.5f, (float)-7.5f, (float)-1.51f));
        Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(68, 63).addBox(-3.0f, -9.75f, 0.5f, 6.0f, 10.0f, 6.0f, cubeDef).texOffs(0, 40).addBox(0.0f, -12.75f, -1.5f, 0.0f, 15.0f, 12.0f, cubeDef), PartPose.offset((float)0.0f, (float)-19.25f, (float)8.49f));
        partdefinition.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(41, 69).addBox(-3.0f, 5.0f, 0.0f, 4.0f, 9.0f, 4.0f, cubeDef).texOffs(54, 0).addBox(-3.0f, -4.0f, -5.0f, 4.0f, 9.0f, 9.0f, cubeDef), PartPose.offset((float)-3.0f, (float)10.0f, (float)6.0f));
        partdefinition.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(0, 74).addBox(-1.0f, 5.0f, 0.0f, 4.0f, 9.0f, 4.0f, cubeDef).texOffs(15, 60).addBox(-1.0f, -4.0f, -5.0f, 4.0f, 9.0f, 9.0f, cubeDef), PartPose.offset((float)3.0f, (float)10.0f, (float)6.0f));
        partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, cubeDef), PartPose.offset((float)-4.9f, (float)13.99f, (float)-8.7f));
        partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(37, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, cubeDef), PartPose.offset((float)4.9f, (float)13.99f, (float)-8.7f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityAngryGlinthop entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Skull.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Skull.xRot = headPitch * ((float)Math.PI / 180);
        float f = (float)Math.PI * 2 + Mth.cos((float)(ageInTicks * 0.05f + limbSwing * 0.1f)) * 0.05f + limbSwingAmount * 0.3f;
        this.LeftWhisker.yRot = this.RightEar.zRot = -f;
        this.RightWhisker.yRot = this.LeftEar.zRot = f;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f2 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.Body.zRot = f1 * 0.05f;
        this.BackRightLeg.xRot = this.FrontLeftLeg.xRot = f1;
        this.BackLeftLeg.xRot = this.FrontRightLeg.xRot = f2;
        this.Tail.yRot = f1 * 0.2f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Spine.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

