/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityWolpertinger;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelWolpertinger
extends EntityModel<EntityWolpertinger> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("wolpertinger");
    private final ModelPart Head;
    private final ModelPart Body;
    private final ModelPart BackRightFoot;
    private final ModelPart BackLeftFoot;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private float jumpRotation;

    public ModelWolpertinger(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.BackRightFoot = root.getChild("BackRightFoot");
        this.BackLeftFoot = root.getChild("BackLeftFoot");
        this.LeftLeg = root.getChild("LeftLeg");
        this.RightLeg = root.getChild("RightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(20, 47).addBox(-2.5f, -4.0f, -5.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(8, 0).addBox(-0.5f, -1.5f, -5.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(26, 21).addBox(-3.0f, -4.5f, -5.5f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(104, 35).addBox(-8.0f, -10.3333f, -8.8333f, 7.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(104, 19).addBox(1.0f, -10.3333f, -8.8333f, 7.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)-4.0f));
        Head.addOrReplaceChild("LeftEar", CubeListBuilder.create().texOffs(44, 47).addBox(-0.5f, -1.5f, -1.0f, 1.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-1.5f, (float)-3.0f));
        Head.addOrReplaceChild("RightEar", CubeListBuilder.create().texOffs(38, 47).addBox(-0.5f, -1.5f, -1.0f, 1.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-1.5f, (float)-3.0f));
        partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(32, 34).addBox(1.0f, -1.6667f, -3.1667f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(29, 0).addBox(-4.0f, -1.6667f, -3.1667f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 21).addBox(-3.0f, -4.6667f, -10.1667f, 6.0f, 6.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.5f, -5.1667f, -10.6667f, 7.0f, 6.0f, 15.0f, new CubeDeformation(0.0f)).texOffs(0, 56).addBox(-2.0f, -4.0f, 3.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)18.6667f, (float)4.1667f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("BackRightFoot", CubeListBuilder.create().texOffs(0, 41).addBox(-1.5f, -0.5f, -8.5f, 3.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)23.5f, (float)7.5f));
        partdefinition.addOrReplaceChild("BackLeftFoot", CubeListBuilder.create().texOffs(42, 4).addBox(-1.5f, -0.5f, -8.5f, 3.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)23.5f, (float)7.5f));
        partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, -1.0f, 3.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)17.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 21).addBox(-4.0f, 0.0f, -1.0f, 3.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)17.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityWolpertinger entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)entity.tickCount;
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.jumpRotation = Mth.sin((float)(entity.getJumpCompletion(f) * (float)Math.PI));
        this.BackLeftFoot.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.BackRightFoot.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.LeftLeg.xRot = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.RightLeg.xRot = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
    }

    public void prepareMobModel(EntityWolpertinger entity, float p_103544_, float p_103545_, float age) {
        super.prepareMobModel((Entity)entity, p_103544_, p_103545_, age);
        this.jumpRotation = Mth.sin((float)(entity.getJumpCompletion(age) * (float)Math.PI));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightFoot.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftFoot.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

