/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntitySeng;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelSeng
extends EntityModel<EntitySeng> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("seng");
    public final ModelPart seng;
    public final ModelPart tail;
    public final ModelPart head;
    public final ModelPart backRightLeg;
    public final ModelPart frontRightLeg;
    public final ModelPart frontLeftLeg;
    public final ModelPart backLeftLeg;

    public ModelSeng(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.seng = root.getChild("seng");
        this.tail = this.seng.getChild("tail");
        this.head = this.seng.getChild("head");
        this.frontRightLeg = root.getChild("frontRightLeg");
        this.frontLeftLeg = root.getChild("frontLeftLeg");
        this.backRightLeg = root.getChild("backRightLeg");
        this.backLeftLeg = root.getChild("backLeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Seng = partdefinition.addOrReplaceChild("seng", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        Seng.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(52, 20).addBox(-4.0f, 1.0f, -4.0f, 2.0f, 2.0f, 4.0f, cubeDef).texOffs(52, 20).addBox(2.0f, 1.0f, -4.0f, 2.0f, 2.0f, 4.0f, cubeDef).texOffs(0, 0).addBox(-4.0f, -7.0f, -10.0f, 8.0f, 8.0f, 18.0f, cubeDef), PartPose.offset((float)0.0f, (float)2.0f, (float)1.0f));
        Seng.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(44, 26).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 3.0f, 4.0f, cubeDef).texOffs(44, 33).addBox(-1.0f, -1.0f, 2.0f, 2.0f, 3.0f, 4.0f, cubeDef).texOffs(46, 0).addBox(-1.0f, 0.0f, 6.0f, 2.0f, 2.0f, 4.0f, cubeDef).texOffs(34, 0).addBox(0.0f, -2.0f, 10.0f, 0.0f, 6.0f, 8.0f, cubeDef).texOffs(26, 0).addBox(-3.0f, 1.0f, 10.0f, 6.0f, 0.0f, 8.0f, cubeDef).texOffs(38, 40).addBox(-1.0f, 0.0f, 10.0f, 2.0f, 2.0f, 6.0f, cubeDef), PartPose.offset((float)0.0f, (float)-4.0f, (float)10.0f));
        Seng.addOrReplaceChild("head", CubeListBuilder.create().texOffs(50, 48).addBox(-3.0f, -1.0f, -6.5f, 6.0f, 3.0f, 1.0f, cubeDef).texOffs(32, 46).addBox(-4.0f, -7.0f, -3.0f, 1.0f, 2.0f, 3.0f, cubeDef).texOffs(47, 11).addBox(3.0f, -7.0f, -3.0f, 1.0f, 2.0f, 3.0f, cubeDef).texOffs(32, 52).addBox(-4.5f, -6.0f, -7.0f, 9.0f, 6.0f, 6.0f, cubeDef).texOffs(0, 26).addBox(-4.0f, -5.0f, -6.0f, 8.0f, 7.0f, 6.0f, cubeDef).texOffs(0, 59).addBox(-4.0f, 2.0f, -6.0f, 8.0f, 2.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)1.01f, (float)-9.0f));
        partdefinition.addOrReplaceChild("frontRightLeg", CubeListBuilder.create().texOffs(0, 39).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 16.0f, 4.0f, cubeDef), PartPose.offset((float)-3.0f, (float)11.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("backRightLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.offset((float)-3.0f, (float)12.0f, (float)8.0f));
        partdefinition.addOrReplaceChild("frontLeftLeg", CubeListBuilder.create().texOffs(28, 26).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 16.0f, 4.0f, cubeDef), PartPose.offset((float)3.0f, (float)11.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("backLeftLeg", CubeListBuilder.create().texOffs(16, 42).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.offset((float)3.0f, (float)12.0f, (float)8.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntitySeng entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.tail.xRot = 0.7853982f;
        this.tail.yRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 1.4f * limbSwingAmount;
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.seng.zRot = f * 0.05f;
        this.frontRightLeg.xRot = this.backLeftLeg.xRot = f1;
        this.backRightLeg.xRot = this.frontLeftLeg.xRot = f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.seng.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.frontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.backRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.frontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.backLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

