/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityHastreus;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelHastreus
extends EntityModel<EntityHastreus> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("hastreus");
    public final ModelPart Body;
    public final ModelPart Tail;
    public final ModelPart Head;
    public final ModelPart Jaw;
    public final ModelPart FrontRightLeg;
    public final ModelPart BackRightLeg;
    public final ModelPart FrontLeftLeg;
    public final ModelPart BackLeftLeg;

    public ModelHastreus(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Tail = this.Body.getChild("Tail");
        this.Head = this.Body.getChild("Head");
        this.Jaw = this.Head.getChild("Jaw");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)10.0f, (float)-10.0f));
        PartDefinition BackRightSpine = Body.addOrReplaceChild("BackRightSpine", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-7.5f, (float)-9.0f, (float)6.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        BackRightSpine.addOrReplaceChild("backrightspine_r1", CubeListBuilder.create().texOffs(48, 84).addBox(-2.5f, -10.0f, -1.0f, 5.0f, 10.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)-0.2618f));
        PartDefinition BackLeftSpine = Body.addOrReplaceChild("BackLeftSpine", CubeListBuilder.create(), PartPose.offsetAndRotation((float)7.5f, (float)-9.0f, (float)6.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        BackLeftSpine.addOrReplaceChild("backleftspine_r1", CubeListBuilder.create().texOffs(86, 24).addBox(-2.5f, -10.0f, -1.0f, 5.0f, 10.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.2618f));
        PartDefinition MiddleRightSpine = Body.addOrReplaceChild("MiddleRightSpine", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.0f, (float)-10.0f, (float)4.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        MiddleRightSpine.addOrReplaceChild("middlerightspine_r1", CubeListBuilder.create().texOffs(65, 83).addBox(-2.0f, -12.0f, -4.5f, 5.0f, 12.0f, 3.0f, cubeDef), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)2.5f, (float)-0.1309f, (float)0.0f, (float)-0.1745f));
        PartDefinition MiddleLeftSpine = Body.addOrReplaceChild("MiddleLeftSpine", CubeListBuilder.create(), PartPose.offsetAndRotation((float)3.0f, (float)-10.0f, (float)4.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        MiddleLeftSpine.addOrReplaceChild("middleleftspine_r1", CubeListBuilder.create().texOffs(81, 83).addBox(-3.0f, -12.0f, -4.5f, 5.0f, 12.0f, 3.0f, cubeDef), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)2.5f, (float)-0.1309f, (float)0.0f, (float)0.1745f));
        PartDefinition CenterSpine = Body.addOrReplaceChild("CenterSpine", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)-1.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        CenterSpine.addOrReplaceChild("centerspine_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -17.0f, -1.5f, 5.0f, 17.0f, 3.0f, cubeDef), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)0.5f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.0f, (float)24.0f));
        Tail.addOrReplaceChild("tailtip_r1", CubeListBuilder.create().texOffs(72, 37).addBox(-2.0f, -8.5f, -3.5f, 4.0f, 7.0f, 9.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)9.5f, (float)0.2182f, (float)0.0f, (float)0.0f));
        Tail.addOrReplaceChild("basetail_r1", CubeListBuilder.create().texOffs(0, 55).addBox(-4.0f, -7.5f, -1.0f, 8.0f, 11.0f, 10.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)-1.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("torso_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-13.5f, -12.0f, -1.0f, 18.0f, 12.0f, 25.0f, cubeDef), PartPose.offsetAndRotation((float)4.5f, (float)2.0f, (float)0.5f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(38, 37).addBox(-2.0f, -2.0f, -12.0f, 4.0f, 6.0f, 2.0f, cubeDef).texOffs(0, 37).addBox(-7.0f, -4.0f, -10.0f, 14.0f, 8.0f, 10.0f, cubeDef), PartPose.offset((float)0.0f, (float)-4.0f, (float)1.0f));
        Head.addOrReplaceChild("headspike_r1", CubeListBuilder.create().texOffs(32, 84).addBox(-2.0f, -7.0f, -1.5f, 4.0f, 8.0f, 4.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-9.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        Head.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(38, 45).addBox(-6.0f, 0.0f, -7.0f, 12.0f, 4.0f, 10.0f, cubeDef), PartPose.offset((float)0.0f, (float)4.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(68, 59).addBox(-8.5f, -2.0f, -3.5f, 8.0f, 16.0f, 8.0f, cubeDef), PartPose.offset((float)-5.5f, (float)10.0f, (float)-5.5f));
        partdefinition.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(36, 59).addBox(-6.5f, -3.0f, -3.5f, 8.0f, 17.0f, 8.0f, cubeDef), PartPose.offset((float)-4.5f, (float)10.0f, (float)9.5f));
        partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(0, 76).addBox(0.5f, -2.0f, -3.5f, 8.0f, 16.0f, 8.0f, cubeDef), PartPose.offset((float)5.5f, (float)10.0f, (float)-5.5f));
        partdefinition.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(61, 0).addBox(-1.5f, -2.0f, -3.5f, 8.0f, 16.0f, 8.0f, cubeDef), PartPose.offset((float)4.5f, (float)10.0f, (float)9.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void prepareMobModel(EntityHastreus entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTick);
        int l = entity.getAttackTick();
        this.Jaw.xRot = l > 0 ? (l > 5 ? Mth.sin((float)(((float)(-4 + l) - partialTick) / 4.0f)) * (float)Math.PI * 0.4f : 0.1571f * Mth.sin((float)((float)Math.PI * ((float)l - partialTick) / 10.0f))) : 0.0f;
    }

    public void setupAnim(EntityHastreus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.Tail.yRot = f / 2.0f;
        this.Body.zRot = f * 0.05f;
        this.FrontRightLeg.xRot = this.BackLeftLeg.xRot = f1;
        this.BackRightLeg.xRot = this.FrontLeftLeg.xRot = f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

