/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityGlacide;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelGlacide
extends EntityModel<EntityGlacide> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("glacide");
    public final ModelPart Spine;
    public final ModelPart RightSail;
    public final ModelPart LeftSail;
    public final ModelPart Head;
    public final ModelPart FrontLeftLeg;
    public final ModelPart FrontLeftLowerLeg;
    public final ModelPart BackLeftLeg;
    public final ModelPart BackLeftLowerLeg;
    public final ModelPart FrontRightLeg;
    public final ModelPart FrontRightLowerLeg;
    public final ModelPart BackRightLeg;
    public final ModelPart BackRightLowerLeg;

    public ModelGlacide(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Spine = root.getChild("Spine");
        this.RightSail = this.Spine.getChild("RightSail");
        this.LeftSail = this.Spine.getChild("LeftSail");
        this.Head = this.Spine.getChild("Head");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
        this.FrontLeftLowerLeg = this.FrontLeftLeg.getChild("FrontLeftLowerLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
        this.BackLeftLowerLeg = this.BackLeftLeg.getChild("BackLeftLowerLeg");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.FrontRightLowerLeg = this.FrontRightLeg.getChild("FrontRightLowerLeg");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.BackRightLowerLeg = this.BackRightLeg.getChild("BackRightLowerLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Spine = partdefinition.addOrReplaceChild("Spine", CubeListBuilder.create().texOffs(46, 35).addBox(-6.0f, -6.0f, -15.0f, 12.0f, 13.0f, 10.0f, cubeDef).texOffs(48, 0).addBox(-6.0f, -2.0f, -5.0f, 12.0f, 11.0f, 9.0f, cubeDef).texOffs(0, 0).addBox(-6.0f, -6.0f, 4.0f, 12.0f, 11.0f, 24.0f, cubeDef).texOffs(90, 0).addBox(-8.0f, 4.0f, -4.0f, 3.0f, 9.0f, 6.0f, cubeDef).texOffs(93, 61).addBox(5.0f, 4.0f, -3.0f, 3.0f, 9.0f, 5.0f, cubeDef), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        Spine.addOrReplaceChild("RightSail", CubeListBuilder.create().texOffs(0, 30).addBox(0.0f, -18.0f, -2.0f, 0.0f, 18.0f, 23.0f, cubeDef), PartPose.offset((float)-5.0f, (float)-6.0f, (float)-7.0f));
        Spine.addOrReplaceChild("LeftSail", CubeListBuilder.create().texOffs(0, 12).addBox(0.0f, -18.0f, -2.0f, 0.0f, 18.0f, 23.0f, cubeDef), PartPose.offset((float)5.0f, (float)-6.0f, (float)-7.0f));
        PartDefinition FrontLeftLeg = partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(90, 40).addBox(0.0f, -5.0f, -3.0f, 3.0f, 16.0f, 5.0f, cubeDef), PartPose.offset((float)5.0f, (float)3.0f, (float)-11.0f));
        FrontLeftLeg.addOrReplaceChild("FrontLeftLowerLeg", CubeListBuilder.create().texOffs(66, 79).addBox(-1.0f, 0.0f, -5.0f, 5.0f, 15.0f, 5.0f, cubeDef), PartPose.offset((float)0.0f, (float)5.99f, (float)-0.99f));
        PartDefinition BackLeftLeg = partdefinition.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(71, 58).addBox(0.0f, -4.0f, -3.0f, 5.0f, 15.0f, 6.0f, cubeDef), PartPose.offset((float)3.0f, (float)3.0f, (float)9.0f));
        BackLeftLeg.addOrReplaceChild("BackLeftLowerLeg", CubeListBuilder.create().texOffs(46, 79).addBox(2.0f, 0.0f, 0.0f, 4.0f, 16.0f, 6.0f, cubeDef), PartPose.offset((float)0.01f, (float)4.99f, (float)0.99f));
        PartDefinition FrontRightLeg = partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(86, 79).addBox(-3.0f, -5.0f, -3.0f, 3.0f, 16.0f, 5.0f, cubeDef), PartPose.offset((float)-5.0f, (float)3.0f, (float)-11.0f));
        FrontRightLeg.addOrReplaceChild("FrontRightLowerLeg", CubeListBuilder.create().texOffs(80, 20).addBox(-4.0f, 0.0f, -5.0f, 5.0f, 15.0f, 5.0f, cubeDef), PartPose.offset((float)0.0f, (float)5.99f, (float)-0.99f));
        PartDefinition BackRightLeg = partdefinition.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -4.0f, -3.0f, 5.0f, 15.0f, 6.0f, cubeDef), PartPose.offset((float)-3.0f, (float)3.0f, (float)9.0f));
        BackRightLeg.addOrReplaceChild("BackRightLowerLeg", CubeListBuilder.create().texOffs(26, 79).addBox(-6.0f, 0.0f, 0.0f, 4.0f, 16.0f, 6.0f, cubeDef), PartPose.offset((float)0.01f, (float)4.99f, (float)0.99f));
        Spine.addOrReplaceChild("Neck", CubeListBuilder.create().texOffs(0, 71).addBox(-4.0f, -19.0f, -5.0f, 8.0f, 23.0f, 5.0f, cubeDef), PartPose.offset((float)0.0f, (float)4.0f, (float)-14.0f));
        Spine.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -4.0f, -12.0f, 2.0f, 3.0f, 0.0f, cubeDef).texOffs(0, 107).addBox(3.0f, -4.0f, -12.0f, 2.0f, 3.0f, 0.0f, cubeDef).texOffs(33, 58).addBox(-3.0f, -4.0f, -12.0f, 6.0f, 8.0f, 13.0f, cubeDef).texOffs(106, 110).addBox(3.0f, -11.0f, -2.0f, 0.0f, 7.0f, 11.0f, cubeDef).texOffs(106, 110).addBox(-3.0f, -11.0f, -2.0f, 0.0f, 7.0f, 11.0f, cubeDef), PartPose.offset((float)0.0f, (float)-15.0f, (float)-18.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityGlacide entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        float f = Mth.cos((float)(limbSwing * 0.6f)) * 0.9f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6f + (float)Math.PI)) * 0.9f * limbSwingAmount;
        float f2 = 0.19634955f + Mth.cos((float)(ageInTicks * 0.05f + limbSwing * 0.2f)) * 0.08f + limbSwingAmount * 0.2f;
        this.Spine.zRot = f * 0.02f;
        this.RightSail.yRot = -f2;
        this.LeftSail.yRot = f2;
        this.FrontRightLeg.xRot = this.BackLeftLeg.xRot = f1;
        this.BackRightLeg.xRot = this.FrontLeftLeg.xRot = f;
        float lowLegMov = Mth.abs((float)Mth.cos((float)(limbSwing * 0.5f))) * 0.7f * limbSwingAmount;
        float lowLegMov1 = Mth.abs((float)Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.FrontRightLowerLeg.xRot = this.BackLeftLowerLeg.xRot = lowLegMov;
        this.BackRightLowerLeg.xRot = this.FrontLeftLowerLeg.xRot = lowLegMov1;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Spine.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

