/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityFrozenFlesh;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelFrozenFlesh
extends EntityModel<EntityFrozenFlesh> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("frozen_flesh");
    public final ModelPart head;
    public final ModelPart torso;
    public final ModelPart base;

    public ModelFrozenFlesh(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.head = root.getChild("head");
        this.torso = root.getChild("torso");
        this.base = root.getChild("base");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 20).addBox(-4.5f, -8.0f, -4.5f, 9.0f, 8.0f, 9.0f, cubeDef), PartPose.offset((float)0.0f, (float)2.02f, (float)0.5f));
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(29, 30).addBox(-4.0f, -9.0f, -3.0f, 8.0f, 11.0f, 7.0f, cubeDef), PartPose.offset((float)0.0f, (float)11.01f, (float)0.0f));
        torso.addOrReplaceChild("right_shoulder", CubeListBuilder.create().texOffs(0, 37).addBox(-1.0f, -3.0f, -2.0f, 1.0f, 5.0f, 5.0f, cubeDef), PartPose.offsetAndRotation((float)-4.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        torso.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(12, 37).addBox(0.0f, -3.0f, -2.0f, 1.0f, 5.0f, 5.0f, cubeDef), PartPose.offsetAndRotation((float)4.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        torso.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(27, 24).addBox(-8.0f, -1.5f, -1.0f, 8.0f, 2.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)-3.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        torso.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(27, 20).addBox(0.0f, -1.5f, -1.0f, 8.0f, 2.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)3.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -4.5f, 10.0f, 11.0f, 9.0f, cubeDef), PartPose.offset((float)0.0f, (float)13.0f, (float)0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityFrozenFlesh entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.torso.yRot = f * 0.15f;
        this.base.yRot = -f * 0.15f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.base.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

