/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntitySoulFiend;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelSoulFiend
extends EntityModel<EntitySoulFiend> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("soul_fiend");
    private final ModelPart body;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart head;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart back;

    public ModelSoulFiend(ModelPart root) {
        this.body = root.getChild("body");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.head = root.getChild("head");
        this.leftarm = root.getChild("leftarm");
        this.rightarm = root.getChild("rightarm");
        this.back = root.getChild("back");
    }

    public ModelSoulFiend(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.head = root.getChild("head");
        this.leftarm = root.getChild("leftarm");
        this.rightarm = root.getChild("rightarm");
        this.back = root.getChild("back");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedef = new CubeDeformation(0.0f);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).mirror().addBox(4.0f, -2.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(12.0f, -2.0f, -2.0f, 3.0f, 3.0f, 4.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(1.0f, -2.0f, -2.0f, 3.0f, 3.0f, 4.0f, cubedef).mirror(false), PartPose.offset((float)-8.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-3.0f, 9.0f, -3.0f, 6.0f, 3.0f, 6.0f, cubedef).mirror(false).texOffs(0, 16).mirror().addBox(-2.0f, -0.1f, -2.0f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(0, 16).mirror().addBox(-3.0f, -4.0f, -3.0f, 6.0f, 5.0f, 6.0f, cubedef).mirror(false), PartPose.offset((float)-4.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-3.0f, 9.0f, -3.0f, 6.0f, 3.0f, 6.0f, cubedef).mirror(false).texOffs(0, 16).mirror().addBox(-2.0f, -0.2f, -2.0f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(0, 16).mirror().addBox(-3.0f, -4.0f, -3.0f, 6.0f, 5.0f, 6.0f, cubedef).mirror(false), PartPose.offset((float)4.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(8, 0).mirror().addBox(-8.0f, -3.0f, -9.0f, 2.0f, 2.0f, 5.0f, cubedef).mirror(false).texOffs(9, 0).mirror().addBox(-8.0f, -6.0f, -4.0f, 4.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(9, 0).mirror().addBox(-8.0f, -3.0f, -4.0f, 4.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(8, 0).mirror().addBox(-8.0f, -6.0f, -9.0f, 2.0f, 2.0f, 5.0f, cubedef).mirror(false).texOffs(0, 0).mirror().addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubedef).mirror(false).texOffs(8, 0).mirror().addBox(-4.0f, -8.0f, -9.0f, 2.0f, 2.0f, 5.0f, cubedef).mirror(false).texOffs(8, 0).mirror().addBox(2.0f, -8.0f, -9.0f, 2.0f, 2.0f, 5.0f, cubedef).mirror(false).texOffs(9, 0).mirror().addBox(4.0f, -3.0f, -4.0f, 4.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(9, 0).mirror().addBox(4.0f, -6.0f, -4.0f, 4.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(8, 0).mirror().addBox(6.0f, -6.0f, -9.0f, 2.0f, 2.0f, 5.0f, cubedef).mirror(false).texOffs(8, 0).mirror().addBox(6.0f, -3.0f, -9.0f, 2.0f, 2.0f, 5.0f, cubedef).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(40, 3).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 20.0f, 4.0f, cubedef).mirror(false), PartPose.offset((float)8.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(40, 3).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 20.0f, 4.0f, cubedef).mirror(false), PartPose.offset((float)-8.0f, (float)2.0f, (float)0.0f));
        PartDefinition back = partdefinition.addOrReplaceChild("back", CubeListBuilder.create().texOffs(8, 0).mirror().addBox(-5.0f, 0.0f, 3.0f, 5.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(8, 0).mirror().addBox(4.0f, 0.0f, 3.0f, 5.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(42, 5).mirror().addBox(4.0f, 4.0f, 3.0f, 8.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(42, 5).mirror().addBox(-8.0f, 4.0f, 3.0f, 8.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(4, 0).mirror().addBox(0.0f, 4.0f, 0.0f, 4.0f, 4.0f, 5.0f, cubedef).mirror(false).texOffs(4, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 5.0f, cubedef).mirror(false), PartPose.offset((float)-2.0f, (float)0.0f, (float)2.0f));
        back.addOrReplaceChild("back12_r1", CubeListBuilder.create().texOffs(34, 26).mirror().addBox(-10.1f, -15.1f, 4.0f, 12.0f, 2.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)24.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.6981f));
        back.addOrReplaceChild("back2_r1", CubeListBuilder.create().texOffs(34, 26).mirror().addBox(-2.0f, -15.1f, 4.0f, 12.0f, 2.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)24.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.6981f));
        back.addOrReplaceChild("back4_r1", CubeListBuilder.create().texOffs(15, 25).mirror().addBox(20.0f, -10.0f, 5.0f, 9.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(15, 25).mirror().addBox(20.0f, 8.0f, 5.0f, 9.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(15, 25).mirror().addBox(24.0f, 5.0f, 5.0f, 9.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(15, 25).mirror().addBox(24.0f, -7.0f, 5.0f, 9.0f, 2.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)24.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(EntitySoulFiend entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightarm.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
        this.leftarm.xRot = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5);
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        this.rightleg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.leftleg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.rightleg.yRot = 0.0f;
        this.leftleg.yRot = 0.0f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.back.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

