/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityQuadro;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelQuadro
extends EntityModel<EntityQuadro> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("quadro");
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart body1;
    private final ModelPart body2;
    private final ModelPart body3;
    private final ModelPart body4;

    public ModelQuadro(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.body1 = root.getChild("body1");
        this.body2 = root.getChild("body2");
        this.body3 = root.getChild("body3");
        this.body4 = root.getChild("body4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedef = new CubeDeformation(0.0f);
        partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(101, 16).mirror().addBox(-4.0f, -4.0f, -3.0f, 6.0f, 4.0f, 6.0f, cubedef).mirror(false).texOffs(0, 16).mirror().addBox(-3.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(19, 17).mirror().addBox(-5.0f, 9.0f, -10.0f, 2.0f, 3.0f, 12.0f, cubedef).mirror(false).texOffs(19, 17).mirror().addBox(1.0f, 9.0f, -10.0f, 2.0f, 3.0f, 12.0f, cubedef).mirror(false), PartPose.offset((float)-7.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(101, 16).mirror().addBox(-3.0f, -4.0f, -3.0f, 6.0f, 4.0f, 6.0f, cubedef).mirror(false).texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(19, 17).mirror().addBox(2.0f, 9.0f, -10.0f, 2.0f, 3.0f, 12.0f, cubedef).mirror(false).texOffs(19, 17).mirror().addBox(-4.0f, 9.0f, -10.0f, 2.0f, 3.0f, 12.0f, cubedef).mirror(false), PartPose.offset((float)8.0f, (float)12.0f, (float)0.0f));
        PartDefinition body1 = partdefinition.addOrReplaceChild("body1", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        body1.addOrReplaceChild("rotated45_r1", CubeListBuilder.create().texOffs(86, 2).mirror().addBox(-5.0f, -16.0f, -8.0f, 10.0f, 4.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)11.9696f, (float)0.3473f, (float)0.1309f, (float)0.0f, (float)0.0f));
        body1.addOrReplaceChild("rotated56_r1", CubeListBuilder.create().texOffs(55, 22).mirror().addBox(6.0f, -17.0f, -21.0f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false).texOffs(55, 22).mirror().addBox(-8.0f, -17.0f, -21.0f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false).texOffs(82, 16).mirror().addBox(-9.0f, -27.0f, -13.0f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(82, 16).mirror().addBox(5.0f, -27.0f, -13.0f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)13.9696f, (float)0.3473f, (float)0.0524f, (float)0.0f, (float)0.0f));
        body1.addOrReplaceChild("rotated27_r1", CubeListBuilder.create().texOffs(61, 28).mirror().addBox(-25.0f, -19.0f, -5.0f, 6.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(61, 28).mirror().addBox(-25.0f, -15.0f, -5.0f, 6.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(58, 24).mirror().addBox(-21.0f, -17.0f, -6.0f, 2.0f, 2.0f, 6.0f, cubedef).mirror(false).texOffs(61, 28).mirror().addBox(-25.0f, -19.0f, 4.0f, 6.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(61, 28).mirror().addBox(-25.0f, -15.0f, 4.0f, 6.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(58, 24).mirror().addBox(-21.0f, -17.0f, 0.0f, 2.0f, 2.0f, 6.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)13.9696f, (float)0.3473f, (float)1.5708f, (float)-1.5184f, (float)-1.5708f));
        body1.addOrReplaceChild("rotated48_r1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-4.0f, -37.0f, -10.0f, 8.0f, 8.0f, 8.0f, cubedef).mirror(false).texOffs(34, 0).mirror().addBox(-3.0f, -30.0f, -7.0f, 6.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(56, 1).mirror().addBox(-4.0f, -22.0f, -8.0f, 8.0f, 7.0f, 6.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)10.9696f, (float)4.3473f, (float)0.4363f, (float)0.0f, (float)0.0f));
        body1.addOrReplaceChild("rotated52_r1", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-7.0f, -26.0f, -10.0f, 4.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(3.0f, -26.0f, -10.0f, 4.0f, 2.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)10.9696f, (float)4.3473f, (float)0.288f, (float)0.0f, (float)0.0f));
        PartDefinition body2 = partdefinition.addOrReplaceChild("body2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        body2.addOrReplaceChild("rotated7_r1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-4.0f, -37.0f, -11.0f, 8.0f, 8.0f, 8.0f, cubedef).mirror(false).texOffs(34, 0).mirror().addBox(-3.0f, -30.0f, -8.0f, 6.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(56, 1).mirror().addBox(-4.0f, -22.0f, -9.0f, 8.0f, 7.0f, 6.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)-1.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        body2.addOrReplaceChild("rotated1_r1", CubeListBuilder.create().texOffs(82, 16).mirror().addBox(5.0f, -23.0f, -18.0f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(55, 22).mirror().addBox(6.0f, -14.0f, -25.0f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)-1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body2.addOrReplaceChild("rotated53_r1", CubeListBuilder.create().texOffs(55, 22).mirror().addBox(-8.0f, -14.0f, -25.6f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false).texOffs(82, 16).mirror().addBox(-9.0f, -23.0f, -18.6f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)11.7f, (float)-1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body2.addOrReplaceChild("rotated49_r1", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-7.0f, -25.5f, -11.25f, 4.0f, 2.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)11.7f, (float)-1.0f, (float)-0.096f, (float)0.0f, (float)0.0f));
        body2.addOrReplaceChild("rotated50_r1", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(3.0f, -26.0f, -11.0f, 4.0f, 2.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)-1.0f, (float)-0.0785f, (float)0.0f, (float)0.0f));
        body2.addOrReplaceChild("rotated14_r1", CubeListBuilder.create().texOffs(86, 2).mirror().addBox(-5.0f, -15.9f, -10.0f, 10.0f, 4.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body3 = partdefinition.addOrReplaceChild("body3", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-7.0f, -15.0f, -7.7f, 4.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(56, 1).mirror().addBox(-4.0f, -10.0f, -9.0f, 8.0f, 7.0f, 6.0f, cubedef).mirror(false).texOffs(34, 0).mirror().addBox(-3.0f, -18.0f, -8.0f, 6.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(0, 0).mirror().addBox(-4.0f, -25.0f, -11.0f, 8.0f, 8.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        body3.addOrReplaceChild("rotated34_r1", CubeListBuilder.create().texOffs(61, 28).mirror().addBox(-29.0f, -13.5f, -2.0f, 6.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(61, 28).mirror().addBox(-29.0f, -13.5f, 0.0f, 6.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(61, 28).mirror().addBox(-29.0f, -11.5f, 0.0f, 6.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(61, 28).mirror().addBox(-29.0f, -11.5f, -2.0f, 6.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(61, 28).mirror().addBox(-29.0f, -19.5f, -2.0f, 6.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(61, 28).mirror().addBox(-29.0f, -19.5f, 0.0f, 6.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(61, 28).mirror().addBox(-29.0f, -17.5f, 0.0f, 6.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(61, 28).mirror().addBox(-29.0f, -17.5f, -2.0f, 6.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(59, 26).mirror().addBox(-25.0f, -15.5f, -4.0f, 2.0f, 2.0f, 4.0f, cubedef).mirror(false).texOffs(59, 26).mirror().addBox(-25.0f, -15.5f, 0.0f, 2.0f, 2.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)-1.5708f, (float)-1.2305f, (float)1.5708f));
        body3.addOrReplaceChild("rotated12_r1", CubeListBuilder.create().texOffs(55, 22).mirror().addBox(8.0f, -14.9f, -24.0f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)-0.3715f, (float)0.1639f, (float)-0.0602f));
        body3.addOrReplaceChild("rotated19_r1", CubeListBuilder.create().texOffs(55, 22).mirror().addBox(-10.0f, -14.9f, -24.0f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)-0.3711f, (float)-0.158f, (float)0.0766f));
        body3.addOrReplaceChild("rotated39_r1", CubeListBuilder.create().texOffs(82, 16).mirror().addBox(5.0f, -24.0f, -17.0f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body3.addOrReplaceChild("rotated37_r1", CubeListBuilder.create().texOffs(82, 16).mirror().addBox(-8.8f, -24.0f, -18.0f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)-0.349f, (float)0.006f, (float)0.0164f));
        body3.addOrReplaceChild("rotated42_r1", CubeListBuilder.create().texOffs(86, 2).mirror().addBox(-5.0f, -16.0f, -11.0f, 10.0f, 4.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        body3.addOrReplaceChild("rotated5_r1", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(3.0f, -26.8f, -8.3f, 4.0f, 2.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition body4 = partdefinition.addOrReplaceChild("body4", CubeListBuilder.create().texOffs(82, 16).mirror().addBox(-8.4f, -13.4415f, -15.8112f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(82, 16).mirror().addBox(5.4f, -13.4415f, -15.8112f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(55, 22).mirror().addBox(-7.0f, -4.4415f, -21.8112f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false).texOffs(55, 22).mirror().addBox(-7.0f, -4.4415f, -29.8112f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false).texOffs(55, 22).mirror().addBox(-7.0f, -4.4415f, -37.8112f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        body4.addOrReplaceChild("rotated8_r1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-4.9f, -36.0f, -9.0f, 8.0f, 8.0f, 8.0f, cubedef).mirror(false).texOffs(34, 0).mirror().addBox(-3.9f, -29.0f, -6.0f, 6.0f, 12.0f, 4.0f, cubedef).mirror(false).texOffs(56, 1).mirror().addBox(-4.9f, -21.0f, -7.0f, 8.0f, 7.0f, 6.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)12.1585f, (float)-0.8112f, (float)0.3142f, (float)0.0f, (float)0.0f));
        body4.addOrReplaceChild("rotated10_r1", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-7.0f, -25.0f, -12.0f, 4.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(2.0f, -25.0f, -12.0f, 4.0f, 2.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)12.1585f, (float)-0.8112f, (float)0.0524f, (float)0.0f, (float)0.0f));
        body4.addOrReplaceChild("rotated18_r1", CubeListBuilder.create().texOffs(86, 2).mirror().addBox(-6.0f, -15.9f, -5.1f, 10.0f, 4.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)12.1585f, (float)-0.8112f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)32);
    }

    public void setupAnim(EntityQuadro entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leftleg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.rightleg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        int ageInSeconds = (int)limbSwingAmount / 20;
        float rotate = 0.0f;
        if (ageInSeconds % 4 == 0) {
            rotate = 0.05f;
        }
        if (ageInSeconds % 16 == 0) {
            this.body1.yRot = 0.0f;
            this.body2.yRot = -1.5708f;
            this.body3.yRot = -3.1416f;
            this.body4.yRot = 1.5708f;
        } else {
            this.body1.yRot += rotate;
            this.body2.yRot += rotate;
            this.body3.yRot += rotate;
            this.body4.yRot += rotate;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

