/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityLadyLuna;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelLadyLuna
extends EntityModel<EntityLadyLuna> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("lady_luna");
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart body1;
    private final ModelPart body;
    private final ModelPart head;

    public ModelLadyLuna(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.leftarm = root.getChild("leftarm");
        this.rightarm = root.getChild("rightarm");
        this.body1 = root.getChild("body1");
        this.body = root.getChild("body");
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedef = new CubeDeformation(0.0f);
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(132, 22).mirror().addBox(1.0f, 18.0f, -7.0f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false).texOffs(132, 22).mirror().addBox(-3.0f, 18.0f, -7.0f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false), PartPose.offset((float)-4.0f, (float)4.0f, (float)1.0f));
        rightleg.addOrReplaceChild("rightleg8_r1", CubeListBuilder.create().texOffs(143, 8).mirror().addBox(-5.0f, -18.0f, -6.4f, 2.0f, 8.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)20.0f, (float)-1.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        rightleg.addOrReplaceChild("rightleg6_r1", CubeListBuilder.create().texOffs(155, 19).mirror().addBox(-5.0f, -11.8f, -1.1f, 2.0f, 11.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)20.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        rightleg.addOrReplaceChild("rightleg5_r1", CubeListBuilder.create().texOffs(133, 9).mirror().addBox(-4.6f, -9.0f, -10.0f, 1.0f, 8.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)20.0f, (float)-1.0f, (float)-0.5066f, (float)0.4204f, (float)0.0174f));
        rightleg.addOrReplaceChild("rightleg4_r1", CubeListBuilder.create().texOffs(156, 10).mirror().addBox(-6.0f, -12.7f, -6.7f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)20.0f, (float)-1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        rightleg.addOrReplaceChild("rightleg3_r1", CubeListBuilder.create().texOffs(172, 1).mirror().addBox(-5.7f, -21.5f, -7.0f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)20.0f, (float)-1.0f, (float)-0.2621f, (float)0.0869f, (float)-0.0076f));
        rightleg.addOrReplaceChild("rightleg2_r1", CubeListBuilder.create().texOffs(133, 9).mirror().addBox(-3.5f, -11.0f, -6.8f, 1.0f, 8.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)20.0f, (float)-1.0f, (float)-0.4171f, (float)-0.4077f, (float)-0.0556f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(172, 1).mirror().addBox(-2.0f, -2.0681f, -2.4824f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false).texOffs(156, 10).mirror().addBox(-2.0f, 6.9319f, -2.4824f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false).texOffs(143, 8).mirror().addBox(-1.0f, 1.9319f, -1.4824f, 2.0f, 8.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)4.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        leftleg.addOrReplaceChild("leftleg7_r1", CubeListBuilder.create().texOffs(132, 22).mirror().addBox(1.0f, -1.0f, -1.3f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)19.9319f, (float)-0.4824f, (float)0.2618f, (float)0.0f, (float)0.0f));
        leftleg.addOrReplaceChild("leftleg6_r1", CubeListBuilder.create().texOffs(155, 19).mirror().addBox(3.0f, -10.0f, 3.3f, 2.0f, 11.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)19.9319f, (float)-0.4824f, (float)0.4363f, (float)0.0f, (float)0.0f));
        leftleg.addOrReplaceChild("leftleg5_r1", CubeListBuilder.create().texOffs(133, 9).mirror().addBox(1.0f, -11.5f, -3.0f, 1.0f, 8.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)19.9319f, (float)-0.4824f, (float)-0.2405f, (float)0.45f, (float)0.1113f));
        leftleg.addOrReplaceChild("leftleg2_r1", CubeListBuilder.create().texOffs(133, 9).mirror().addBox(1.0f, -10.8f, -4.0f, 1.0f, 8.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)19.9319f, (float)-0.4824f, (float)-0.2256f, (float)-0.2555f, (float)-0.1166f));
        leftleg.addOrReplaceChild("leftleg1_r1", CubeListBuilder.create().texOffs(132, 22).mirror().addBox(-1.0f, 13.4f, -5.2f, 2.0f, 2.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)4.9319f, (float)-0.4824f, (float)0.2618f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(111, 3).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false).texOffs(236, 3).mirror().addBox(0.0f, 2.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubedef).mirror(false).texOffs(236, 9).mirror().addBox(0.0f, 10.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubedef).mirror(false).texOffs(237, 23).mirror().addBox(-1.0f, 17.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false).texOffs(174, 17).mirror().addBox(0.0f, 19.0f, -9.0f, 2.0f, 3.0f, 12.0f, cubedef).mirror(false).texOffs(193, 1).mirror().addBox(0.5f, 19.5f, -18.0f, 1.0f, 2.0f, 9.0f, cubedef).mirror(false).texOffs(152, 1).mirror().addBox(-1.0f, 19.0f, 3.0f, 4.0f, 3.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)5.0f, (float)-14.25f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(236, 9).mirror().addBox(-1.0f, 10.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubedef).mirror(false).texOffs(236, 3).mirror().addBox(-1.0f, 2.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubedef).mirror(false).texOffs(111, 3).mirror().addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false).texOffs(203, 24).mirror().addBox(1.0f, 20.0f, -14.0f, 1.0f, 1.0f, 6.0f, cubedef).mirror(false).texOffs(212, 13).mirror().addBox(-2.0f, 17.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false).texOffs(137, 1).mirror().addBox(-1.0f, 18.0f, -5.0f, 2.0f, 2.0f, 4.0f, cubedef).mirror(false).texOffs(219, 23).mirror().addBox(-2.0f, 17.0f, -8.0f, 4.0f, 4.0f, 3.0f, cubedef).mirror(false).texOffs(203, 24).mirror().addBox(1.0f, 17.0f, -14.0f, 1.0f, 1.0f, 6.0f, cubedef).mirror(false).texOffs(203, 24).mirror().addBox(-2.0f, 20.0f, -14.0f, 1.0f, 1.0f, 6.0f, cubedef).mirror(false).texOffs(203, 24).mirror().addBox(-2.0f, 17.0f, -14.0f, 1.0f, 1.0f, 6.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-6.0f, (float)-14.5f, (float)-3.0f, (float)0.1047f, (float)0.0f, (float)0.1745f));
        PartDefinition body1 = partdefinition.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(116, 13).mirror().addBox(-5.0f, 3.0f, 7.0f, 1.0f, 9.0f, 4.0f, cubedef).mirror(false).texOffs(116, 13).mirror().addBox(4.0f, 3.0f, 7.0f, 1.0f, 9.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)2.1817f, (float)0.0f, (float)0.0f));
        body1.addOrReplaceChild("part5_r1", CubeListBuilder.create().texOffs(116, 13).mirror().addBox(-4.0f, 14.0f, 3.0f, 1.0f, 9.0f, 4.0f, cubedef).mirror(false).texOffs(116, 13).mirror().addBox(3.0f, 14.0f, 3.0f, 1.0f, 9.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-13.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        body1.addOrReplaceChild("part8_r1", CubeListBuilder.create().texOffs(116, 13).mirror().addBox(-5.0f, 13.0f, -4.0f, 1.0f, 9.0f, 4.0f, cubedef).mirror(false).texOffs(116, 13).mirror().addBox(4.0f, 13.0f, -4.0f, 1.0f, 9.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-13.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(100, 12).mirror().addBox(-2.0f, -4.0f, -1.0f, 6.0f, 9.0f, 2.0f, cubedef).mirror(false).texOffs(89, 23).mirror().addBox(-3.0f, -8.0f, -2.0f, 8.0f, 5.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-9.0f, (float)-1.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("part4_r1", CubeListBuilder.create().texOffs(62, 19).mirror().addBox(-4.0f, -29.0f, -4.5f, 8.0f, 9.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)33.0f, (float)1.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(3, 8).mirror().addBox(-2.0f, -3.9136f, -1.8389f, 4.0f, 5.0f, 2.0f, cubedef).mirror(false).texOffs(0, 0).mirror().addBox(-3.0f, -6.9136f, -3.8389f, 6.0f, 4.0f, 4.0f, cubedef).mirror(false).texOffs(81, 7).mirror().addBox(-3.0f, -13.9136f, -7.8389f, 1.0f, 1.0f, 8.0f, cubedef).mirror(false).texOffs(53, 1).mirror().addBox(-3.0f, -12.9136f, -1.8389f, 1.0f, 3.0f, 1.0f, cubedef).mirror(false).texOffs(81, 7).mirror().addBox(2.0f, -13.9136f, -7.8389f, 1.0f, 1.0f, 8.0f, cubedef).mirror(false).texOffs(53, 1).mirror().addBox(2.0f, -12.9136f, -1.8389f, 1.0f, 3.0f, 1.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-17.0f, (float)-3.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("part26_r1", CubeListBuilder.create().texOffs(45, 6).mirror().addBox(-5.0f, -46.25f, -3.0f, 1.0f, 1.0f, 2.0f, cubedef).mirror(false).texOffs(53, 0).mirror().addBox(3.0f, -53.25f, -4.0f, 2.0f, 3.0f, 7.0f, cubedef).mirror(false).texOffs(73, 0).mirror().addBox(-5.0f, -50.25f, -4.0f, 1.0f, 4.0f, 7.0f, cubedef).mirror(false).texOffs(53, 0).mirror().addBox(-5.0f, -53.25f, -4.0f, 2.0f, 3.0f, 7.0f, cubedef).mirror(false).texOffs(25, 5).mirror().addBox(-3.0f, -51.25f, 2.0f, 6.0f, 1.0f, 1.0f, cubedef).mirror(false).texOffs(57, 11).mirror().addBox(-3.0f, -52.25f, -4.0f, 6.0f, 1.0f, 7.0f, cubedef).mirror(false).texOffs(26, 9).mirror().addBox(-4.0f, -50.25f, 2.0f, 8.0f, 4.0f, 1.0f, cubedef).mirror(false).texOffs(73, 0).mirror().addBox(4.0f, -50.25f, -4.0f, 1.0f, 4.0f, 7.0f, cubedef).mirror(false).texOffs(83, 0).mirror().addBox(-5.0f, -46.25f, -1.0f, 10.0f, 1.0f, 4.0f, cubedef).mirror(false).texOffs(45, 6).mirror().addBox(4.0f, -46.25f, -3.0f, 1.0f, 1.0f, 2.0f, cubedef).mirror(false).texOffs(23, 0).mirror().addBox(-5.0f, -46.25f, -6.0f, 10.0f, 1.0f, 3.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)42.0864f, (float)2.1611f, (float)0.0436f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)32);
    }

    public void setupAnim(EntityLadyLuna entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leftleg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.rightleg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.rightarm.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
        this.leftarm.xRot = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5 + (double)0.1047198f);
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

