/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityKitra;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelKitra
extends EntityModel<EntityKitra> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("kitra");
    private final ModelPart Head;
    private final ModelPart Torso;
    private final ModelPart RightFin;
    private final ModelPart LeftFin;
    private final ModelPart TailBase;

    public ModelKitra(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Head = root.getChild("Head");
        this.Torso = root.getChild("Torso");
        this.RightFin = root.getChild("RightFin");
        this.LeftFin = root.getChild("LeftFin");
        this.TailBase = root.getChild("TailBase");
    }

    public ModelKitra(ModelPart root) {
        this.Head = root.getChild("Head");
        this.Torso = root.getChild("Torso");
        this.RightFin = root.getChild("RightFin");
        this.LeftFin = root.getChild("LeftFin");
        this.TailBase = root.getChild("TailBase");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-22.0f, (float)-19.0f));
        Head.addOrReplaceChild("skull_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-19.0f, -7.0f, -47.0f, 38.0f, 24.0f, 48.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)-1.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Torso = partdefinition.addOrReplaceChild("Torso", CubeListBuilder.create().texOffs(0, 72).addBox(-21.0f, -10.0f, -1.0f, 42.0f, 23.0f, 42.0f, new CubeDeformation(0.0f)).texOffs(0, 224).addBox(-2.0f, -15.0f, -1.0f, 4.0f, 8.0f, 41.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-26.0f, (float)-17.0f));
        PartDefinition RightFin = partdefinition.addOrReplaceChild("RightFin", CubeListBuilder.create(), PartPose.offset((float)-24.0f, (float)-18.0f, (float)0.0f));
        RightFin.addOrReplaceChild("rightfin_r1", CubeListBuilder.create().texOffs(0, 137).addBox(-6.0f, -5.0f, 1.0f, 8.0f, 34.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)4.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition LeftFin = partdefinition.addOrReplaceChild("LeftFin", CubeListBuilder.create(), PartPose.offset((float)24.0f, (float)-18.0f, (float)0.0f));
        LeftFin.addOrReplaceChild("leftfin_r1", CubeListBuilder.create().texOffs(52, 137).addBox(-1.0f, -5.0f, 1.0f, 8.0f, 34.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)4.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        Torso.addOrReplaceChild("Hip", CubeListBuilder.create().texOffs(126, 72).addBox(-16.0f, 1.0f, -1.0f, 32.0f, 19.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(94, 248).addBox(-2.0f, -5.0f, 1.0f, 4.0f, 8.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-10.0f, (float)39.0f));
        PartDefinition TailBase = partdefinition.addOrReplaceChild("TailBase", CubeListBuilder.create().texOffs(104, 137).addBox(-13.0f, -2.0f, -1.5f, 26.0f, 18.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(221, 0).addBox(-2.0f, -9.0f, -0.5f, 4.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-32.0f, (float)38.5f));
        PartDefinition TailSegment1 = TailBase.addOrReplaceChild("TailSegment1", CubeListBuilder.create().texOffs(291, 0).addBox(-2.0f, -8.5f, -1.25f, 4.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(168, 107).addBox(-11.0f, -1.5f, -1.25f, 22.0f, 12.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)10.75f));
        PartDefinition TailSegment2 = TailSegment1.addOrReplaceChild("TailSegment2", CubeListBuilder.create().texOffs(168, 107).addBox(-11.0f, -1.5f, -0.5f, 22.0f, 12.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(415, 0).addBox(-2.0f, -8.5f, -0.5f, 4.0f, 8.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)10.25f));
        PartDefinition TailSegment3 = TailSegment2.addOrReplaceChild("TailSegment3", CubeListBuilder.create().texOffs(168, 107).addBox(-11.0f, -1.5f, 0.0f, 22.0f, 12.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(415, 0).addBox(-2.0f, -8.5f, 1.0f, 4.0f, 8.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)10.5f));
        TailSegment3.addOrReplaceChild("TailTip", CubeListBuilder.create().texOffs(0, 360).addBox(0.0f, -4.5f, 0.5f, 0.0f, 13.0f, 31.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)11.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)512, (int)512);
    }

    public void setupAnim(EntityKitra entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.RightFin.zRot = (float)(-Math.sin((double)(10.0f * ageInTicks) / 57.29577951308232) * (double)0.3f);
        this.LeftFin.zRot = (float)(Math.sin((double)(10.0f * ageInTicks) / 57.29577951308232) * (double)0.3f);
        this.TailBase.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)limbSwingAmount / 4.0);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightFin.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftFin.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.TailBase.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

