/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.boss.EntityDramix;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelDramix<E extends EntityDivineMonster>
extends EntityModel<EntityDramix> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("dramix");
    private final ModelPart Leg_Right;
    private final ModelPart Leg_Left;
    private final ModelPart Arm_Right;
    private final ModelPart Arm_Left;
    private final ModelPart Head;
    private final ModelPart Chest;

    public ModelDramix(ModelPart root) {
        this.Leg_Right = root.getChild("Leg_Right");
        this.Leg_Left = root.getChild("Leg_Left");
        this.Arm_Right = root.getChild("Arm_Right");
        this.Arm_Left = root.getChild("Arm_Left");
        this.Head = root.getChild("Head");
        this.Chest = root.getChild("Chest");
    }

    public ModelDramix(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Leg_Right = root.getChild("Leg_Right");
        this.Leg_Left = root.getChild("Leg_Left");
        this.Arm_Right = root.getChild("Arm_Right");
        this.Arm_Left = root.getChild("Arm_Left");
        this.Head = root.getChild("Head");
        this.Chest = root.getChild("Chest");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedef = new CubeDeformation(0.0f);
        partdefinition.addOrReplaceChild("Leg_Right", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, -2.0f, -3.0f, 5.0f, 15.0f, 6.0f, cubedef).mirror(false), PartPose.offset((float)-4.0f, (float)11.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("Leg_Left", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-3.0f, -2.0f, -3.0f, 5.0f, 15.0f, 6.0f, cubedef).mirror(false), PartPose.offset((float)4.0f, (float)11.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("Arm_Right", CubeListBuilder.create().texOffs(22, 22).mirror().addBox(-2.0f, -2.0f, -3.0f, 4.0f, 16.0f, 6.0f, cubedef).mirror(false), PartPose.offset((float)-8.0f, (float)-5.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("Arm_Left", CubeListBuilder.create().texOffs(22, 22).mirror().addBox(-2.0f, -2.0f, -3.0f, 4.0f, 16.0f, 6.0f, cubedef).mirror(false), PartPose.offset((float)8.0f, (float)-5.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(36, 0).mirror().addBox(-3.0f, -5.0f, -3.0f, 6.0f, 10.0f, 6.0f, cubedef).mirror(false), PartPose.offset((float)0.0f, (float)-12.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("Chest", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-6.0f, -7.0f, -2.0f, 12.0f, 16.0f, 6.0f, cubedef).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityDramix entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Arm_Right.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
        this.Arm_Left.xRot = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5);
        this.Arm_Right.zRot = 0.0f;
        this.Leg_Left.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.Leg_Right.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.Leg_Left.yRot = 0.0f;
        this.Leg_Right.yRot = 0.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.Leg_Right.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.Leg_Left.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.Arm_Right.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.Arm_Left.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.Head.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.Chest.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

