/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.arcana;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelRejuvGolem<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("rejuv_golem");
    private final ModelPart head;
    private final ModelPart rightshoulder;
    private final ModelPart leftshoulder;
    private final ModelPart middle;
    private final ModelPart body;
    private final ModelPart rightarm;
    private final ModelPart leftarm;

    public ModelRejuvGolem(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.head = root.getChild("head");
        this.rightshoulder = root.getChild("rightshoulder");
        this.leftshoulder = root.getChild("leftshoulder");
        this.middle = root.getChild("middle");
        this.body = root.getChild("body");
        this.rightarm = root.getChild("rightarm");
        this.leftarm = root.getChild("leftarm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-4.0f, -8.0f, -4.0f, 4.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)7.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightshoulder", CubeListBuilder.create().texOffs(73, 3).mirror().addBox(-4.0f, -6.0f, -3.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-6.0f, (float)11.0f, (float)0.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftshoulder", CubeListBuilder.create().texOffs(73, 3).mirror().addBox(-2.0f, -6.0f, -3.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.0f, (float)11.0f, (float)0.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("middle", CubeListBuilder.create().texOffs(68, 18).mirror().addBox(-4.0f, 0.0f, -2.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)7.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(25, 10).mirror().addBox(-4.0f, 0.0f, -2.0f, 10.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.0f, (float)12.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-6.0f, (float)11.0f, (float)0.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.0f, (float)11.0f, (float)0.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightarm.xRot = this.rightshoulder.xRot = Mth.cos((float)limbSwing) * limbSwingAmount * 0.75f - 0.6981317f;
        this.leftarm.xRot = this.leftshoulder.xRot = Mth.cos((float)(limbSwing + (float)Math.PI)) * limbSwingAmount * 0.75f - 0.6981317f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightshoulder.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftshoulder.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.middle.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

