/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.arcana;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelParatiku<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("paratiku");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart WingRT;
    private final ModelPart WingRB;
    private final ModelPart WingLB;
    private final ModelPart WingLT;
    private final ModelPart Shape1;
    private final ModelPart Shape2;
    private final ModelPart Shape3;

    public ModelParatiku(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.WingRT = root.getChild("WingRT");
        this.WingRB = root.getChild("WingRB");
        this.WingLB = root.getChild("WingLB");
        this.WingLT = root.getChild("WingLT");
        this.Shape1 = root.getChild("Shape1");
        this.Shape2 = root.getChild("Shape2");
        this.Shape3 = root.getChild("Shape3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 7).mirror().addBox(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)6.0f, (float)-8.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(19, 0).mirror().addBox(-6.0f, -10.0f, -7.0f, 12.0f, 22.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)11.0f, (float)2.0f, (float)0.8644f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("WingRT", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-14.0f, 0.0f, -5.0f, 14.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-6.0f, (float)7.0f, (float)0.0f, (float)-0.733f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("WingRB", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-14.0f, 0.0f, -5.0f, 14.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-6.0f, (float)14.0f, (float)0.0f, (float)-0.733f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("WingLB", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, 0.0f, -5.0f, 14.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.0f, (float)14.0f, (float)0.0f, (float)-0.733f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("WingLT", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, 0.0f, -5.0f, 14.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.0f, (float)7.0f, (float)0.0f, (float)-0.733f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("Shape1", CubeListBuilder.create().texOffs(13, 21).mirror().addBox(0.0f, 0.0f, 0.0f, 2.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)4.0f, (float)10.0f, (float)-0.2603f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("Shape2", CubeListBuilder.create().texOffs(13, 21).mirror().addBox(0.0f, 0.0f, 0.0f, 2.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-4.0f, (float)0.0f, (float)-0.2603f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("Shape3", CubeListBuilder.create().texOffs(13, 21).mirror().addBox(0.0f, 0.0f, 0.0f, 2.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)5.0f, (float)-0.2603f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch / 57.295776f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.zRot = 0.0f;
        this.body.xRot = 0.7853982f + Mth.cos((float)(ageInTicks * 0.1f)) * 0.15f;
        this.body.yRot = 0.0f;
        this.WingRT.yRot = Mth.cos((float)(ageInTicks * 1.3f)) * (float)Math.PI * 0.25f;
        this.WingLT.yRot = -this.WingRT.yRot;
        this.WingRB.yRot = Mth.cos((float)(ageInTicks * 1.3f)) * (float)Math.PI * 0.25f;
        this.WingLB.yRot = -this.WingRB.yRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.WingRT.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.WingRB.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.WingLB.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.WingLT.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Shape1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Shape2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Shape3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

