/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.arcana;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.arcana.EntityDeathHound;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelDeathHound
extends EntityModel<EntityDeathHound> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("death_hound");
    private final ModelPart Body;
    private final ModelPart Leg1;
    private final ModelPart Leg2;
    private final ModelPart Leg3;
    private final ModelPart Leg4;
    private final ModelPart Leg5;

    public ModelDeathHound(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Leg1 = root.getChild("Leg1");
        this.Leg2 = root.getChild("Leg2");
        this.Leg3 = root.getChild("Leg3");
        this.Leg4 = root.getChild("Leg4");
        this.Leg5 = root.getChild("Leg5");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(43, 16).mirror().addBox(-4.0f, -7.5f, -9.0f, 2.0f, 4.0f, 1.0f, CubeDeformation.NONE).mirror(false).texOffs(43, 16).mirror().addBox(0.0f, -7.5f, -9.0f, 2.0f, 4.0f, 1.0f, CubeDeformation.NONE).mirror(false).texOffs(0, 0).mirror().addBox(-4.0f, -3.5f, -14.0f, 6.0f, 6.0f, 6.0f, CubeDeformation.NONE).mirror(false).texOffs(0, 19).mirror().addBox(-2.5f, -0.5f, -18.0f, 3.0f, 3.0f, 4.0f, CubeDeformation.NONE).mirror(false).texOffs(21, 0).mirror().addBox(-5.0f, -3.0f, -8.0f, 8.0f, 9.0f, 7.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)1.0f, (float)14.0f, (float)2.0f));
        Body.addOrReplaceChild("Tail2_r1", CubeListBuilder.create().texOffs(9, 18).mirror().addBox(-0.1f, 4.1842f, 11.7133f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE).mirror(false).texOffs(9, 18).mirror().addBox(-3.9f, 4.1842f, 11.7133f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-2.0f, (float)1.117f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("Body_r1", CubeListBuilder.create().texOffs(18, 14).mirror().addBox(-4.0f, -10.0f, -11.0f, 6.0f, 9.0f, 6.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-2.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("Leg1", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-1.5f, (float)16.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("Leg2", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)1.5f, (float)16.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("Leg3", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(-1.0f, 0.0f, -3.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)0.0f, (float)16.0f, (float)-7.0f));
        partdefinition.addOrReplaceChild("Leg4", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)1.5f, (float)16.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("Leg5", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-1.5f, (float)16.0f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(EntityDeathHound entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Leg1.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.Leg2.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.Leg3.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.Leg4.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.Leg5.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg5.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

