/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models;

import com.google.common.collect.ImmutableList;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelHat<T extends Player>
extends ListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("hat");
    public ModelPart hat;

    public ModelHat(ModelPart root) {
        this.hat = root.getChild("hat");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition hat = partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -18.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.NONE), PartPose.ZERO);
        hat.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(32, 0).addBox(-6.0f, -10.0f, -6.0f, 12.0f, 2.0f, 12.0f, CubeDeformation.NONE), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)80, (int)16);
    }

    public void setupAnim(Player entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.hat.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.hat.xRot = headPitch * ((float)Math.PI / 180);
    }

    public Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.hat);
    }
}

