/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.menu;

import divinerpg.block_entities.furnace.InfiniFurnaceBlockEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class InfiniFurnaceMenu
extends RecipeBookMenu<RecipeInput, Recipe<RecipeInput>> {
    private final Container container;
    private final ContainerData data;
    protected final Level level;

    public InfiniFurnaceMenu(MenuType<?> type, int i, Inventory inv) {
        this(type, i, inv, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(2));
    }

    public InfiniFurnaceMenu(MenuType<?> type, int num, Inventory inv, Container container, ContainerData data) {
        super(type, num);
        InfiniFurnaceMenu.checkContainerSize((Container)container, (int)2);
        InfiniFurnaceMenu.checkContainerDataCount((ContainerData)data, (int)2);
        this.container = container;
        this.data = data;
        this.level = inv.player.level();
        this.addSlot(new Slot(container, 0, 56, 17));
        this.addSlot((Slot)new FurnaceResultSlot(this, inv.player, container, 1, 116, 35){

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
                if (player instanceof ServerPlayer) {
                    ((InfiniFurnaceBlockEntity)this.container).awardUsedRecipesAndPopExperience((ServerPlayer)player);
                }
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inv, k, 8 + k * 18, 142));
        }
        this.addDataSlots(data);
    }

    public void fillCraftSlotsStackedContents(StackedContents contents) {
        if (this.container instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.container).fillStackedContents(contents);
        }
    }

    public void clearCraftingContent() {
        this.getSlot(0).set(ItemStack.EMPTY);
        this.getSlot(1).set(ItemStack.EMPTY);
    }

    public boolean recipeMatches(RecipeHolder<Recipe<RecipeInput>> recipe) {
        return recipe.value().matches((RecipeInput)new SingleRecipeInput(this.container.getItem(0)), this.level);
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public int getResultSlotIndex() {
        return 1;
    }

    public int getGridWidth() {
        return 1;
    }

    public int getGridHeight() {
        return 1;
    }

    public int getSize() {
        return 2;
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.FURNACE;
    }

    public boolean shouldMoveToInventory(int i) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i == 1) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (i != 0 ? (this.canSmelt(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (i >= 2 && i < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : i >= 29 && i < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false))) : !this.moveItemStackTo(itemstack1, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    protected boolean canSmelt(ItemStack stack) {
        return this.level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), this.level).isPresent();
    }

    public int getBurnProgress() {
        int i = this.data.get(0);
        int j = this.data.get(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public boolean isLit() {
        return !this.container.getItem(0).isEmpty();
    }
}

