/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.menu;

import divinerpg.registries.ItemRegistry;
import divinerpg.registries.MenuTypeRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DreamLampMenu
extends AbstractContainerMenu {
    private final Container container;
    protected final Level level;

    public DreamLampMenu(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory);
    }

    public DreamLampMenu(int i, Inventory inv) {
        this(i, inv, (Container)new SimpleContainer(1));
    }

    public DreamLampMenu(int num, Inventory inv, Container container) {
        super((MenuType)MenuTypeRegistry.DREAM_LAMP.get(), num);
        DreamLampMenu.checkContainerSize((Container)container, (int)1);
        this.container = container;
        this.level = inv.player.level();
        this.addSlot(new Slot(container, 0, 80, 47));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inv, k, 8 + k * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i == 0) {
                if (!this.moveItemStackTo(itemstack1, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (itemstack1.is(ItemRegistry.acid) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (i > 0 && i < 28 ? !this.moveItemStackTo(itemstack1, 28, 37, false) : i > 27 && i < 37 && !this.moveItemStackTo(itemstack1, 1, 28, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

