/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vethea;

import divinerpg.blocks.base.PortalBlock;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.LevelRegistry;
import divinerpg.util.UniversalPosition;
import divinerpg.world.placement.Surface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.portal.DimensionTransition;

public class VetheaPortal
extends PortalBlock {
    public VetheaPortal() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_PORTAL), LevelRegistry.VETHEA, LevelRegistry.MORTUM, (Block)BlockRegistry.mortumBlock.get(), null);
    }

    @Override
    public BlockPos applyPlacementLocationPreference(ServerLevel level, Entity entity, BlockPos pos) {
        DimensionTransition d;
        ServerPlayer p;
        if (level.dimension() == this.rootDimension) {
            return new BlockPos(pos.getX(), Surface.getSurface(Surface.Surface_Type.LOWEST_GROUND, Surface.Mode.FULL, level.getMinBuildHeight(), 32, 0, (WorldGenLevel)level, level.getRandom(), pos.getX(), pos.getZ()), pos.getZ());
        }
        if (entity instanceof ServerPlayer && (p = (ServerPlayer)entity).getRespawnDimension() == level.dimension() && (d = p.findRespawnPositionAndUseSpawnBlock(true, DimensionTransition.DO_NOTHING)) != null) {
            return UniversalPosition.toBlockPos(d.pos());
        }
        return pos;
    }

    @Override
    public boolean hasRoomForPortal(ServerLevel level, BlockPos pos) {
        return level.getBlockState(pos).isAir() || level.getBlockState(pos.above()).isAir();
    }

    @Override
    public BlockPos placePortal(ServerLevel level, BlockPos pos, Direction.Axis axis) {
        return pos;
    }
}

