/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vethea;

import divinerpg.block_entities.NightmareBedBlockEntity;
import divinerpg.blocks.vethea.VetheaPortal;
import divinerpg.config.CommonConfig;
import divinerpg.registries.BlockRegistry;
import divinerpg.util.LocalizeUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public class BlockNightmareBed
extends BedBlock {
    public BlockNightmareBed() {
        super(DyeColor.BLACK, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).ignitedByLava().pushReaction(PushReaction.DESTROY).strength(0.2f).sound(SoundType.WOOD));
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.getInventory().isEmpty() || !CommonConfig.Values.SAFER_VETHEA) {
            if (!worldIn.isClientSide()) {
                if (worldIn.getChunkSource().getLightEngine().getLayerListener(LightLayer.BLOCK).getLightValue(pos) < 7 && worldIn.getChunkSource().getLightEngine().getLayerListener(LightLayer.SKY).getLightValue(pos) < 7) {
                    ((ServerPlayer)player).setRespawnPosition(worldIn.dimension(), pos, 0.0f, false, false);
                    player.changeDimension(((VetheaPortal)((Object)BlockRegistry.vetheaPortal.get())).getPortalDestination((ServerLevel)worldIn, (Entity)player, pos));
                } else {
                    Component message = LocalizeUtils.clientMessage(ChatFormatting.RED, "nightmare_bed.restrict", player.getDisplayName());
                    player.displayClientMessage(message, true);
                }
            }
        } else {
            Component message = LocalizeUtils.clientMessage(ChatFormatting.RED, "nightmare_bed.inventory_full", player.getDisplayName());
            player.displayClientMessage(message, true);
        }
        return InteractionResult.CONSUME;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NightmareBedBlockEntity(pos, state);
    }
}

