/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vethea;

import divinerpg.blocks.vethea.BlockVetheaAltar;
import divinerpg.entities.boss.EntityKaros;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class BlockKarosAltar
extends BlockVetheaAltar {
    public BlockKarosAltar() {
        super(MapColor.WARPED_WART_BLOCK);
    }

    protected BlockPos findSafeBossSpawnPos(Level worldIn, BlockPos pos, int radius) {
        RandomSource rand = worldIn.random;
        for (int i = 0; i < 10; ++i) {
            int x = pos.getX() + rand.nextInt(radius * 2) - radius;
            int y = pos.getY();
            int z = pos.getZ() + rand.nextInt(radius * 2) - radius;
            BlockPos spawnPos = new BlockPos(x, y, z);
            AABB bossHitbox = this.getBoss(worldIn).getBoundingBox().move((double)x, (double)y, (double)z);
            if (!worldIn.noCollision((Entity)this.getBoss(worldIn), bossHitbox)) continue;
            return spawnPos;
        }
        return null;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockPos bossSpawnPos = this.findSafeBossSpawnPos(world, pos, 10);
        if (bossSpawnPos != null && stack.getItem() == this.acceptedItem()) {
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            player.getCooldowns().addCooldown(stack.getItem(), 40);
            stack.consume(1, (LivingEntity)player);
            this.spawnBoss(world, bossSpawnPos.above());
            return ItemInteractionResult.SUCCESS;
        }
        this.onFailure();
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected Item acceptedItem() {
        return (Item)ItemRegistry.dream_flint.get();
    }

    @Override
    protected LivingEntity getBoss(Level world) {
        return new EntityKaros((EntityType<? extends EntityKaros>)((EntityType)EntityRegistry.KAROS.get()), world);
    }

    @Override
    protected void onFailure() {
    }
}

