/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vanilla;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class FireBlock
extends BaseFireBlock {
    public static final MapCodec<FireBlock> CODEC = FireBlock.simpleCodec(FireBlock::new);

    public MapCodec<FireBlock> codec() {
        return CODEC;
    }

    public FireBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FIRE).mapColor(MapColor.FIRE), 8.0f);
    }

    public FireBlock(BlockBehaviour.Properties properties) {
        super(properties, 8.0f);
    }

    public FireBlock(float fireDamage) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FIRE).mapColor(MapColor.FIRE), fireDamage);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (!entity.isAlive()) {
            level.playSound(entity, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.NEUTRAL, 0.6f, 1.3f);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if ((level.getGameTime() & 3L) == 0L) {
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.04, 0.0);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState s, LevelAccessor level, BlockPos pos, BlockPos p) {
        BlockPos po = pos.below();
        BlockState st = level.getBlockState(po);
        return !st.isAir() && st.isFaceSturdy((BlockGetter)level, po, Direction.UP) ? this.defaultBlockState() : Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(BlockState s, LevelReader level, BlockPos pos) {
        BlockPos p = pos.below();
        BlockState state = level.getBlockState(p);
        return !state.isAir() && state.isFaceSturdy((BlockGetter)level, p, Direction.UP);
    }

    protected boolean canBurn(BlockState state) {
        return !state.isAir();
    }
}

