/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vanilla;

import divinerpg.blocks.base.BlockMod;
import divinerpg.registries.DamageRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class BlockSpike
extends BlockMod {
    private final boolean isHot;

    public BlockSpike(boolean isHot, MapColor color) {
        super(BlockBehaviour.Properties.of().mapColor(color).strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL));
        this.isHot = isHot;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            if (this.isHot) {
                entityIn.hurt(level.damageSources().source(DamageRegistry.SPIKE.getKey()), 8.0f);
                entityIn.igniteForSeconds(10.0f);
            } else {
                entityIn.hurt(level.damageSources().source(DamageRegistry.SPIKE.getKey()), 5.0f);
            }
        }
    }
}

