/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vanilla;

import divinerpg.blocks.base.BlockMod;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockRandomItemDropper
extends BlockMod {
    public BlockRandomItemDropper() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DROPPER));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DirectionalBlock.FACING, BlockStateProperties.TRIGGERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)DirectionalBlock.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)DirectionalBlock.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mir) {
        return this.rotate(state, mir.getRotation((Direction)state.getValue((Property)DirectionalBlock.FACING)));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos p, boolean b) {
        if (!level.isClientSide()) {
            boolean hasSignal = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
            boolean triggered = (Boolean)state.getValue((Property)BlockStateProperties.TRIGGERED);
            if (triggered && !hasSignal) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
            } else if (hasSignal && !triggered) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
                Set keys = BuiltInRegistries.ITEM.keySet();
                Direction dir = (Direction)state.getValue((Property)DirectionalBlock.FACING);
                ItemEntity i = new ItemEntity(level, (double)(pos.getX() + dir.getStepX()) + 0.5, (double)(pos.getY() + dir.getStepY()), (double)(pos.getZ() + dir.getStepZ()) + 0.5, new ItemStack((ItemLike)BuiltInRegistries.ITEM.get((ResourceLocation)keys.toArray()[level.random.nextInt(keys.size())])));
                i.setDeltaMovement(i.getDeltaMovement().add((double)dir.getStepX() * 0.5, (double)dir.getStepY() * 0.5, (double)dir.getStepZ() * 0.5));
                level.addFreshEntity((Entity)i);
                level.playSound(null, pos, SoundEvents.DISPENSER_DISPENSE, SoundSource.BLOCKS);
            }
        }
    }
}

