/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vanilla;

import divinerpg.blocks.base.BlockMod;
import divinerpg.registries.BlockRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class BlockHellfireSponge
extends BlockMod {
    public BlockHellfireSponge() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPONGE).mapColor(MapColor.FIRE));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState s, boolean b) {
        if (this.tryRemoveWater(level, pos.above(), 64) | this.tryRemoveWater(level, pos.below(), 64) | this.tryRemoveWater(level, pos.north(), 64) | this.tryRemoveWater(level, pos.south(), 64) | this.tryRemoveWater(level, pos.east(), 64) | this.tryRemoveWater(level, pos.west(), 64)) {
            level.setBlock(pos, ((Block)BlockRegistry.coldHellfireSponge.get()).defaultBlockState(), 3);
            level.playLocalSound(pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    protected boolean tryRemoveWater(Level level, BlockPos pos, int distance) {
        if (distance > 0) {
            --distance;
            boolean b = false;
            BlockState state = level.getBlockState(pos);
            if (state.is(Blocks.WATER) || state.is(Blocks.BUBBLE_COLUMN) || state.is(Blocks.SEAGRASS) || state.is(Blocks.TALL_SEAGRASS)) {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                b = true;
            } else if (state.is(Blocks.KELP) || state.is(Blocks.KELP_PLANT)) {
                state.onDestroyedByPlayer(level, pos, null, true, level.getFluidState(pos));
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                b = true;
            } else {
                Optional o = state.getOptionalValue((Property)BlockStateProperties.WATERLOGGED);
                if (o.isPresent() && ((Boolean)o.get()).booleanValue()) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
                    b = true;
                }
            }
            if (b) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 0.1, 0.0);
                this.tryRemoveWater(level, pos.above(), distance);
                this.tryRemoveWater(level, pos.below(), distance);
                this.tryRemoveWater(level, pos.north(), distance);
                this.tryRemoveWater(level, pos.south(), distance);
                this.tryRemoveWater(level, pos.east(), distance);
                this.tryRemoveWater(level, pos.west(), distance);
            }
            return b;
        }
        return false;
    }
}

