/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.twilight;

import divinerpg.blocks.twilight.TwilightFire;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.Utils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.CommonHooks;

public class MortumEmbers
extends TwilightFire {
    public static final ResourceLocation ADVANCEMENT = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"twilight/curses");

    public MortumEmbers() {
        super(25.0f);
    }

    @Override
    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (entity instanceof Player) {
            Player p = (Player)entity;
            Registry lookup = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            int cursed = MortumEmbers.curse((Registry<Enchantment>)lookup, p, EquipmentSlot.MAINHAND) + MortumEmbers.curse((Registry<Enchantment>)lookup, p, EquipmentSlot.OFFHAND) + MortumEmbers.curse((Registry<Enchantment>)lookup, p, EquipmentSlot.HEAD) + MortumEmbers.curse((Registry<Enchantment>)lookup, p, EquipmentSlot.CHEST) + MortumEmbers.curse((Registry<Enchantment>)lookup, p, EquipmentSlot.LEGS) + MortumEmbers.curse((Registry<Enchantment>)lookup, p, EquipmentSlot.FEET);
            if (cursed > 0) {
                p.playSound((SoundEvent)SoundRegistry.DEEP_LAUGH.get(), 0.6f, 0.8f);
                p.playSound(SoundEvents.SCULK_SHRIEKER_SHRIEK, 0.6f, 0.7f);
                if (level instanceof ServerLevel) {
                    ServerLevel s = (ServerLevel)level;
                    s.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 9 * cursed, 0.5, 0.5, 0.5, 0.0);
                    s.sendParticles((ParticleOptions)ParticleTypes.SOUL, p.getX(), p.getEyeY(), p.getZ(), 5 * cursed, 0.25, 0.25, 0.25, 0.0);
                    Utils.awardAdvancement(s.getServer(), (ServerPlayer)p, ADVANCEMENT, "use_mortum_embers");
                }
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
        }
    }

    public static int curse(Registry<Enchantment> enchantments, Player p, EquipmentSlot slot) {
        List list;
        Optional tag;
        ItemStack stack = p.getItemBySlot(slot);
        if (!stack.isEmpty() && stack.isEnchantable() && !EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)EnchantmentTags.CURSE) && (tag = enchantments.getTag(EnchantmentTags.CURSE)).isPresent() && !(list = EnchantmentHelper.selectEnchantment((RandomSource)p.getRandom(), (ItemStack)stack, (int)30, (Stream)((HolderSet.Named)tag.get()).stream())).isEmpty()) {
            stack = stack.getItem().applyEnchantments(stack, list);
            CommonHooks.onPlayerEnchantItem((Player)p, (ItemStack)stack, (List)list);
            p.awardStat(Stats.ENCHANT_ITEM);
            if (p instanceof ServerPlayer) {
                ServerPlayer s = (ServerPlayer)p;
                CriteriaTriggers.ENCHANTED_ITEM.trigger(s, stack, 0);
            }
            p.setItemSlot(slot, stack);
            return 1;
        }
        return 0;
    }
}

