/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.twilight;

import divinerpg.blocks.twilight.TwilightFire;
import divinerpg.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class DivineFlame
extends TwilightFire {
    public static final ResourceLocation ADVANCEMENT = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"divine/ritual_or_not");

    @Override
    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (entity instanceof Player) {
            Player p = (Player)entity;
            HolderLookup.RegistryLookup lookup = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            int cursesRemoed = DivineFlame.removeCurses((HolderLookup.RegistryLookup<Enchantment>)lookup, p, EquipmentSlot.HEAD) + DivineFlame.removeCurses((HolderLookup.RegistryLookup<Enchantment>)lookup, p, EquipmentSlot.CHEST) + DivineFlame.removeCurses((HolderLookup.RegistryLookup<Enchantment>)lookup, p, EquipmentSlot.LEGS) + DivineFlame.removeCurses((HolderLookup.RegistryLookup<Enchantment>)lookup, p, EquipmentSlot.FEET) + DivineFlame.removeCurses((HolderLookup.RegistryLookup<Enchantment>)lookup, p, EquipmentSlot.MAINHAND) + DivineFlame.removeCurses((HolderLookup.RegistryLookup<Enchantment>)lookup, p, EquipmentSlot.OFFHAND);
            if (cursesRemoed > 0) {
                p.hurt(level.damageSources().magic(), (float)(cursesRemoed * 4));
                p.playSound(SoundEvents.SCULK_SHRIEKER_SHRIEK, 0.6f, 0.7f);
                p.playSound((SoundEvent)SoundEvents.TRIDENT_THUNDER.value(), 1.0f, 0.5f);
                if (level instanceof ServerLevel) {
                    ServerLevel s = (ServerLevel)level;
                    s.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 7 * cursesRemoed, 0.5, 0.5, 0.5, 0.0);
                    s.sendParticles((ParticleOptions)ParticleTypes.SOUL, p.getX(), p.getEyeY(), p.getZ(), 7 * cursesRemoed, 0.25, 0.25, 0.25, 0.0);
                    Utils.awardAdvancement(s.getServer(), (ServerPlayer)p, ADVANCEMENT, "remove_curse");
                }
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
        }
    }

    public static int removeCurses(HolderLookup.RegistryLookup<Enchantment> enchantmentLookup, Player p, EquipmentSlot slot) {
        ItemStack stack = p.getItemBySlot(slot);
        if (EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)EnchantmentTags.CURSE)) {
            ItemEnchantments.Mutable mut = new ItemEnchantments.Mutable(stack.getAllEnchantments(enchantmentLookup));
            mut.removeIf(e -> e.is(EnchantmentTags.CURSE));
            EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)mut.toImmutable());
            p.setItemSlot(slot, stack);
            return 1;
        }
        return 0;
    }
}

