/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.iceika;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.Nullable;

public class OxdriteRail
extends PoweredRailBlock {
    public OxdriteRail() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POWERED_RAIL), true);
    }

    protected void registerDefaultState() {
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SHAPE, (Comparable)RailShape.NORTH_SOUTH)).setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getShapeProperty(), BlockStateProperties.POWER, POWERED, WATERLOGGED});
    }

    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        return super.getRailMaxSpeed(state, level, pos, cart) * (float)((Integer)state.getValue((Property)BlockStateProperties.POWER) + 1) / 16.0f;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    protected void updateState(BlockState state, Level level, BlockPos pos, Block block) {
        RailShape railshape = (RailShape)state.getValue(this.getShapeProperty());
        int max = level.getBestNeighborSignal(pos);
        if (max < 15 && this.hasAscendingConnection(railshape, Direction.NORTH)) {
            max = Math.max(max, level.getSignal(pos.north().below(), Direction.NORTH));
        }
        if (max < 15 && this.hasAscendingConnection(railshape, Direction.SOUTH)) {
            max = Math.max(max, level.getSignal(pos.south().below(), Direction.SOUTH));
        }
        if (max < 15 && this.hasAscendingConnection(railshape, Direction.WEST)) {
            max = Math.max(max, level.getSignal(pos.west().below(), Direction.WEST));
        }
        if (max < 15 && this.hasAscendingConnection(railshape, Direction.EAST)) {
            max = Math.max(max, level.getSignal(pos.east().below(), Direction.EAST));
        }
        max = Math.max(0, max - 1);
        if ((Integer)state.getValue((Property)BlockStateProperties.POWER) != max) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(max))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(max > 0)), 3);
        }
    }

    protected boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED);
    }

    protected int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        RailShape railshape = (RailShape)state.getValue(this.getShapeProperty());
        int power = (Integer)state.getValue((Property)BlockStateProperties.POWER);
        return power > 0 && this.hasConnection(railshape, direction) ? power : 0;
    }

    public boolean hasAscendingConnection(RailShape railshape, Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> {
                if (railshape == RailShape.NORTH_SOUTH || railshape == RailShape.ASCENDING_NORTH) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (railshape == RailShape.NORTH_SOUTH || railshape == RailShape.ASCENDING_SOUTH) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (railshape == RailShape.EAST_WEST || railshape == RailShape.ASCENDING_WEST) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (railshape == RailShape.EAST_WEST || railshape == RailShape.ASCENDING_EAST) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean hasConnection(RailShape railshape, Direction dir) {
        return switch (dir) {
            case Direction.NORTH, Direction.SOUTH -> {
                if (railshape == RailShape.NORTH_SOUTH || railshape == RailShape.ASCENDING_NORTH || railshape == RailShape.ASCENDING_SOUTH) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST, Direction.EAST -> {
                if (railshape == RailShape.EAST_WEST || railshape == RailShape.ASCENDING_EAST || railshape == RailShape.ASCENDING_WEST) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    protected int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getSignal(state, level, pos, direction);
    }
}

