/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.iceika;

import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.WeepingVinesPlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockWinterberryVinesBody
extends WeepingVinesPlantBlock
implements BonemealableBlock {
    public static final BooleanProperty RIPE = BlockStateProperties.BLOOM;

    public BlockWinterberryVinesBody(BlockBehaviour.Properties properties) {
        super(properties.randomTicks().lightLevel(state -> (Boolean)state.getValue((Property)RIPE) != false ? 5 : 1).dynamicShape());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)RIPE, (Comparable)Boolean.valueOf(false)));
    }

    protected GrowingPlantHeadBlock getHeadBlock() {
        return (GrowingPlantHeadBlock)BlockRegistry.winterberryVinesHead.get();
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)RIPE) == false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextFloat() < 0.11f) {
            level.setBlock(pos, (BlockState)state.setValue((Property)RIPE, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)RIPE, (Comparable)Boolean.valueOf(true)), 2);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)RIPE) == false || super.isValidBonemealTarget(level, pos, state);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockState aboveState = level.getBlockState(pos.above());
        if (aboveState.getBlock() == BlockRegistry.winterberryVinesBody.get() && ((Boolean)aboveState.getValue((Property)RIPE)).booleanValue()) {
            BlockWinterberryVinesBody.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)new ItemStack((ItemLike)ItemRegistry.winterberry.get(), 1));
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)RIPE)).booleanValue()) {
            BlockWinterberryVinesBody.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemRegistry.winterberry.get(), 1));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlock(pos, (BlockState)state.setValue((Property)RIPE, (Comparable)Boolean.valueOf(false)), 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RIPE});
    }

    public int getFlammability(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return 15;
    }
}

