/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.iceika;

import com.mojang.serialization.MapCodec;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlockIcyFire
extends BaseFireBlock {
    public static final MapCodec<BlockIcyFire> CODEC = BlockIcyFire.simpleCodec(BlockIcyFire::new);

    public MapCodec<BlockIcyFire> codec() {
        return CODEC;
    }

    public BlockIcyFire(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> 7), 1.0f);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!entity.isAlive()) {
            return;
        }
        if (entity.isOnFire()) {
            entity.extinguishFire();
        }
        if (entity.canFreeze() && !entity.isInLava()) {
            entity.setTicksFrozen(entity.getTicksFrozen() + 4);
            if (entity.tickCount % 15 == 0) {
                entity.hurt(level.damageSources().freeze(), 1.0f);
                if (!entity.isAlive()) {
                    level.playSound(null, pos, (SoundEvent)SoundRegistry.FREEZE.get(), SoundSource.BLOCKS, 0.8f, 1.5f);
                }
            }
        }
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState s, LevelAccessor level, BlockPos pos, BlockPos p) {
        return this.canBurn(level.getBlockState(pos.below())) ? this.defaultBlockState() : Blocks.AIR.defaultBlockState();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    public boolean canSurvive(BlockState s, LevelReader level, BlockPos pos) {
        return this.canBurn(level.getBlockState(pos.below()));
    }

    protected boolean canBurn(BlockState state) {
        return state.is(BlockTags.SNOW) || state.is(BlockTags.ICE);
    }
}

