/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.iceika;

import divinerpg.block_entities.chests.FrostedChestBlockEntity;
import divinerpg.blocks.base.BlockModChest;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.ParticleRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockFrostedChest
extends BlockModChest {
    public BlockFrostedChest() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ICE).strength(2.5f).randomTicks().noOcclusion(), () -> (BlockEntityType)BlockEntityRegistry.FROSTED_CHEST.get());
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos.MutableBlockPos p = pos.offset(2, 2, 2).mutable();
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 5; ++y) {
                for (int z = 0; z < 5; ++z) {
                    if (level.getBlockState((BlockPos)p).is(Blocks.WATER) && random.nextInt(x == 0 || x == 4 || y == 0 || y == 4 || z == 0 || z == 4 ? 4 : 2) == 0) {
                        level.setBlock((BlockPos)p, Blocks.ICE.defaultBlockState(), 3);
                        return;
                    }
                    p.move(0, 0, -1);
                }
                p.move(0, -1, 5);
            }
            p.move(-1, 5, 0);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    public ItemStack pickupBlock(Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        return ItemStack.EMPTY;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Shapes.block();
        }
        return super.getShape(state, getter, pos, context);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new FrostedChestBlockEntity(p_153215_, p_153216_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        RandomSource random = rand;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.getX() + random.nextFloat();
            double d2 = (float)pos.getY() + random.nextFloat();
            double d3 = (float)pos.getZ() + random.nextFloat();
            if (i == 0 && !worldIn.getBlockState(pos.above()).canOcclude()) {
                d2 = (double)pos.getY() + 0.0625 + 1.0;
            }
            if (i == 1 && !worldIn.getBlockState(pos.below()).canOcclude()) {
                d2 = (double)pos.getY() - 0.0625;
            }
            if (i == 2 && !worldIn.getBlockState(pos.south()).canOcclude()) {
                d3 = (double)pos.getZ() + 0.0625 + 1.0;
            }
            if (i == 3 && !worldIn.getBlockState(pos.north()).canOcclude()) {
                d3 = (double)pos.getZ() - 0.0625;
            }
            if (i == 4 && !worldIn.getBlockState(pos.east()).canOcclude()) {
                d1 = (double)pos.getX() + 0.0625 + 1.0;
            }
            if (i == 5 && !worldIn.getBlockState(pos.west()).canOcclude()) {
                d1 = (double)pos.getX() - 0.0625;
            }
            if (!(d1 < (double)pos.getX() || d1 > (double)(pos.getX() + 1) || d2 < 0.0 || d2 > (double)(pos.getY() + 1) || d3 < (double)pos.getZ()) && !(d3 > (double)(pos.getZ() + 1)) || rand.nextInt(10) > 5) continue;
            worldIn.addParticle((ParticleOptions)ParticleRegistry.FROST.get(), d1, d2, d3, 0.0, 0.5, 0.0);
        }
    }
}

