/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.DivineRPG;
import divinerpg.block_entities.block.PortalBlockEntity;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.util.UniversalPosition;
import divinerpg.world.placement.Surface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortalBlock
extends BaseEntityBlock
implements Portal {
    public static final VoxelShape X_AXIS_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    public static final VoxelShape Z_AXIS_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public final ResourceKey<Level> rootDimension;
    public final ResourceKey<Level> chainDimension;
    public final Block frameBlock;
    public final ResourceLocation particleLocation;
    public SimpleParticleType particle;
    public static final MapCodec<PortalBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PortalBlock.propertiesCodec(), (App)ResourceLocation.CODEC.fieldOf("target_dimension").forGetter(PortalBlock::rootDimension), (App)ResourceLocation.CODEC.fieldOf("chain_dimension").forGetter(PortalBlock::chainDimension), (App)Block.CODEC.fieldOf("frame_block").forGetter(PortalBlock::frameBlock), (App)ResourceLocation.CODEC.fieldOf("particle").forGetter(PortalBlock::particle)).apply((Applicative)instance, PortalBlock::new));

    public PortalBlock(BlockBehaviour.Properties properties, ResourceKey<Level> rootDimension, ResourceKey<Level> chainDimension, Block frameBlock, ResourceLocation particle) {
        super(properties);
        this.rootDimension = rootDimension;
        this.chainDimension = chainDimension;
        this.frameBlock = frameBlock;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X));
        this.particleLocation = particle;
    }

    public PortalBlock(BlockBehaviour.Properties properties, ResourceLocation rootDimension, ResourceLocation chainDimension, Block frameBlock, ResourceLocation particle) {
        this(properties, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)rootDimension), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)chainDimension), frameBlock, particle);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.PORTAL.get()).create(pos, state);
    }

    public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        if (PortalBlock.hasConnection(level, pos)) {
            return PortalBlock.transitionTo(level.getServer(), entity, ((PortalBlockEntity)level.getBlockEntity((BlockPos)pos)).targetPosition);
        }
        BlockState state = level.getBlockState(pos);
        Direction.Axis axis = state.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS) ? (Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) : null;
        ResourceKey<Level> targetDimension = level.dimension() == this.rootDimension ? this.chainDimension : this.rootDimension;
        ServerLevel targetLevel = level.getServer().getLevel(targetDimension);
        BlockPos targetPosition = PortalBlock.scalePosition(pos, level.dimensionType(), targetLevel.dimensionType());
        UniversalPosition origin = new UniversalPosition((Level)level, pos);
        pos = targetPosition;
        for (int tries = 0; tries < 10 && !this.hasRoomForPortal(targetLevel, pos = this.applyPlacementLocationPreference(targetLevel, entity, pos)); ++tries) {
            pos = tries == 9 ? targetPosition : targetPosition.offset((int)((entity.getRandom().nextFloat() - 0.5f) * (float)(tries << 2)), 0, (int)((entity.getRandom().nextFloat() - 0.5f) * (float)(tries << 2)));
        }
        targetPosition = this.placePortal(targetLevel, pos, axis);
        if (targetPosition == null) {
            return null;
        }
        UniversalPosition target = new UniversalPosition(targetDimension, targetPosition);
        this.linkPortals(level.getServer(), origin, target);
        return PortalBlock.transitionTo(level.getServer(), entity, target);
    }

    public BlockPos applyPlacementLocationPreference(ServerLevel level, Entity entity, BlockPos pos) {
        BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos(pos.getX(), Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, level.getMinBuildHeight(), level.dimensionType().logicalHeight() + 2, 0, (WorldGenLevel)level, level.getRandom(), pos.getX(), pos.getZ()), pos.getZ());
        while (level.getBlockState((BlockPos)m).is(Blocks.WATER)) {
            m.move(0, 1, 0);
        }
        return m.move(0, -1, 0);
    }

    public boolean hasRoomForPortal(ServerLevel level, BlockPos pos) {
        return level.getBlockState((pos = pos.above()).above()).isAir() && level.getBlockState(pos.north()).isAir() && level.getBlockState(pos.east()).isAir() && level.getBlockState(pos.south()).isAir() && level.getBlockState(pos.west()).isAir();
    }

    public BlockPos placePortal(ServerLevel level, BlockPos pos, Direction.Axis axis) {
        return null;
    }

    public static BlockPos placeVanillaLookingPortal(ServerLevel level, BlockPos pos, BlockState frameBlock, BlockState portalBlock, Direction.Axis axis) {
        if (!level.ensureCanWrite(pos)) {
            return null;
        }
        Block p = portalBlock.getBlock();
        for (int x = -3; x < 4; ++x) {
            for (int y = -3; y < 4; ++y) {
                for (int z = -3; z < 4; ++z) {
                    if (!level.getBlockState(pos.offset(x, y, z)).is(p)) continue;
                    return pos.offset(x, y, z);
                }
            }
        }
        Direction.Axis other = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        BlockState air = Blocks.AIR.defaultBlockState();
        BlockPos.MutableBlockPos mut = pos.mutable();
        PortalBlock.setBlock(level, (BlockPos)mut, frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.set((Vec3i)mut.relative(axis, 1)), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.DOWN), portalBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.DOWN), portalBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.DOWN), portalBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.DOWN), frameBlock);
        if (level.getBlockState((BlockPos)mut.set((Vec3i)mut.relative(other, 1))).isAir()) {
            level.setBlock((BlockPos)mut, frameBlock, 16);
        }
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), air);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), air);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), air);
        PortalBlock.setBlock(level, (BlockPos)mut.set((Vec3i)mut.relative(axis, 1)), air);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.DOWN), air);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.DOWN), air);
        if (level.getBlockState((BlockPos)mut.move(Direction.DOWN)).isAir()) {
            level.setBlock((BlockPos)mut, frameBlock, 16);
        }
        PortalBlock.setBlock(level, (BlockPos)mut.set((Vec3i)mut.relative(other, -1)), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.set((Vec3i)mut.relative(axis, 1)), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.set((Vec3i)mut.relative(axis, -1)), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.DOWN), portalBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.DOWN), portalBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.DOWN), portalBlock);
        PortalBlock.setBlock(level, (BlockPos)mut.set((Vec3i)mut.relative(other, -1)), air);
        if (level.getBlockState((BlockPos)mut.move(Direction.DOWN)).isAir()) {
            level.setBlock((BlockPos)mut, frameBlock, 16);
        }
        if (level.getBlockState((BlockPos)mut.set((Vec3i)mut.relative(axis, -1))).isAir()) {
            level.setBlock((BlockPos)mut, frameBlock, 16);
        }
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), air);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), air);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.UP), air);
        PortalBlock.setBlock(level, (BlockPos)mut.set((Vec3i)mut.relative(axis, 1)), air);
        PortalBlock.setBlock(level, (BlockPos)mut.move(Direction.DOWN), air);
        return mut.set((Vec3i)mut.relative(other, 1).below());
    }

    public static void setBlock(ServerLevel level, BlockPos pos, BlockState state) {
        BlockState block = level.getBlockState(pos);
        if (state.isAir() || block.getBlock().defaultDestroyTime() > -1.0f) {
            level.setBlock(pos, state, 16);
            if (state.getBlock() instanceof PortalBlock) {
                level.setBlockEntity(((BlockEntityType)BlockEntityRegistry.PORTAL.get()).create(pos, state));
            }
        }
    }

    public static boolean hasConnection(ServerLevel level, BlockPos pos) {
        PortalBlockEntity p;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof PortalBlockEntity && (p = (PortalBlockEntity)blockEntity).hasTargetPos() && PortalBlock.hasPortal(level.getServer(), p.targetPosition);
    }

    public static boolean hasPortal(MinecraftServer server, UniversalPosition target) {
        return target.level(server).getBlockState(target.blockPos()).is(BlockTags.PORTALS);
    }

    public static BlockPos scalePosition(BlockPos pos, DimensionType originDimension, DimensionType targetDimension) {
        double scale = DimensionType.getTeleportationScale((DimensionType)originDimension, (DimensionType)targetDimension);
        return new BlockPos((int)((double)pos.getX() * scale), pos.getZ(), (int)((double)pos.getZ() * scale));
    }

    public static DimensionTransition transitionTo(MinecraftServer server, Entity entity, UniversalPosition pos) {
        return new DimensionTransition(pos.level(server), pos.pos().add(0.5, 0.0, 0.5), entity.getKnownMovement(), entity.getYRot(), entity.getXRot(), false, DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET));
    }

    public void linkPortals(MinecraftServer server, UniversalPosition origin, UniversalPosition target) {
        if (!PortalBlock.hasPortal(server, origin) || !PortalBlock.hasPortal(server, target)) {
            return;
        }
        ServerLevel level = origin.level(server);
        BlockPos pos = origin.blockPos();
        this.connectTo(level, pos, target, (Direction.Axis)level.getBlockState(pos).getValue((Property)BlockStateProperties.HORIZONTAL_AXIS));
        level = target.level(server);
        pos = target.blockPos();
        this.connectTo(level, pos, origin, (Direction.Axis)level.getBlockState(pos).getValue((Property)BlockStateProperties.HORIZONTAL_AXIS));
    }

    public static void spreadBlock(Level level, BlockState newState, BlockPos pos, Block spreadTarget, Direction.Axis axis) {
        BlockState state = level.getBlockState(pos);
        if (state.is(spreadTarget) && !state.is(newState.getBlock())) {
            level.setBlock(pos, newState, 16);
            PortalBlock.spreadBlock(level, newState, pos.above(), spreadTarget, axis);
            PortalBlock.spreadBlock(level, newState, pos.below(), spreadTarget, axis);
            PortalBlock.spreadBlock(level, newState, pos.relative(axis, 1), spreadTarget, axis);
            PortalBlock.spreadBlock(level, newState, pos.relative(axis, -1), spreadTarget, axis);
        }
        level.sendBlockUpdated(pos, spreadTarget.defaultBlockState(), newState, 3);
    }

    public void connectTo(ServerLevel level, BlockPos pos, @NotNull UniversalPosition connection, Direction.Axis axis) {
        BlockEntity b = level.getBlockEntity(pos);
        BlockState state = level.getBlockState(pos);
        if (b == null && state.getBlock() instanceof PortalBlock) {
            b = ((BlockEntityType)BlockEntityRegistry.PORTAL.get()).create(pos, state);
            level.setBlockEntity(b);
        }
        if (b instanceof PortalBlockEntity) {
            PortalBlockEntity portal = (PortalBlockEntity)b;
            if (connection != portal.targetPosition && !connection.equals(portal.targetPosition)) {
                portal.targetPosition = connection;
                this.connectTo(level, pos.above(), connection, axis);
                this.connectTo(level, pos.below(), connection, axis);
                this.connectTo(level, pos.relative(axis, 1), connection, axis);
                this.connectTo(level, pos.relative(axis, -1), connection, axis);
            }
        }
    }

    public Direction.Axis checkForFrame(Level level, BlockPos pos) {
        Direction d = null;
        for (Direction di : Direction.values()) {
            if (!level.getBlockState(pos.relative(di)).is(this.frameBlock)) continue;
            d = di;
            break;
        }
        if (d == null) {
            return null;
        }
        return this.travel(level, pos, Direction.Axis.X) ? Direction.Axis.X : (this.travel(level, pos, Direction.Axis.Z) ? Direction.Axis.Z : null);
    }

    protected boolean travel(Level level, BlockPos pos, Direction.Axis axis) {
        BlockState state;
        Direction d;
        Direction dir = d = this.lookForFrameBlock(level, pos, axis);
        if (d == null) {
            return false;
        }
        BlockPos.MutableBlockPos mut = pos.mutable();
        while ((dir = dir.getClockWise(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X)) != d) {
            state = level.getBlockState(mut.relative(dir));
            if (state.is(this.frameBlock)) continue;
            if (state.isAir()) break;
            return false;
        }
        if (dir == d) {
            return true;
        }
        d = dir;
        mut.move(d);
        while (mut.distManhattan((Vec3i)pos) < 33 && !mut.equals((Object)pos)) {
            if (!level.getBlockState(mut.relative(d.getCounterClockWise(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X))).is(this.frameBlock)) {
                return false;
            }
            do {
                if ((state = level.getBlockState(mut.relative(dir))).is(this.frameBlock)) continue;
                if (state.isAir()) {
                    d = dir;
                    break;
                }
                return false;
            } while ((dir = dir.getClockWise(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X)) != d);
            mut.move(d);
        }
        return level.getBlockState(mut.relative(d.getCounterClockWise(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X))).is(this.frameBlock) && mut.equals((Object)pos);
    }

    protected Direction lookForFrameBlock(Level level, BlockPos pos, Direction.Axis axis) {
        Direction d;
        Direction dir = d = axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH;
        do {
            if (!level.getBlockState(pos.relative(dir)).is(this.frameBlock)) continue;
            return dir;
        } while ((dir = dir.getClockWise(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X)) != d);
        return null;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.rotate((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)context.getHorizontalDirection().getAxis()), Rotation.CLOCKWISE_90);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.isSupported(state, (LevelReader)level, pos) ? state : Blocks.AIR.defaultBlockState();
    }

    protected void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (!this.isSupported(pState, (LevelReader)pLevel, pPos)) {
            pLevel.setBlock(pPos, Blocks.AIR.defaultBlockState(), 3);
        } else {
            super.neighborChanged(pState, pLevel, pPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
        }
    }

    public boolean isSupported(BlockState state, LevelReader level, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
        return this.supportedBy(level.getBlockState(pos.above())) && this.supportedBy(level.getBlockState(pos.below())) && this.supportedBy(level.getBlockState(pos.relative(axis, 1))) && this.supportedBy(level.getBlockState(pos.relative(axis, -1)));
    }

    public boolean supportedBy(BlockState state) {
        return state.is(BlockTags.PORTALS) || state.is(this.frameBlock);
    }

    public int getPortalTransitionTime(ServerLevel level, Entity entity) {
        int n;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            n = Math.max(1, level.getGameRules().getInt(player.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        } else {
            n = 0;
        }
        return n;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public ResourceLocation rootDimension() {
        return this.rootDimension.location();
    }

    public ResourceLocation chainDimension() {
        return this.chainDimension.location();
    }

    public ResourceLocation particle() {
        return this.particleLocation;
    }

    public Block frameBlock() {
        return this.frameBlock;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(true)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) == Direction.Axis.Z ? Z_AXIS_AABB : X_AXIS_AABB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_AXIS});
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                    case Z: {
                        yield (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.particleLocation != null) {
            if (this.particle == null) {
                this.particle = (SimpleParticleType)BuiltInRegistries.PARTICLE_TYPE.get(this.particleLocation);
                if (this.particle == null) {
                    DivineRPG.LOGGER.warn("Null particle ResourceLocation");
                }
            }
            level.addParticle((ParticleOptions)this.particle, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }
}

